/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.s3.domain.BucketMetadata;
import org.jclouds.s3.domain.CanonicalUser;
import org.jclouds.util.SaxUtils;

public class ListAllMyBucketsHandler
extends ParseSax.HandlerWithResult<Set<BucketMetadata>> {
    private Set<BucketMetadata> buckets = Sets.newLinkedHashSet();
    private CanonicalUser currentOwner;
    private StringBuilder currentText = new StringBuilder();
    private final DateService dateParser;
    private String currentName;
    private Date currentCreationDate;

    @Inject
    public ListAllMyBucketsHandler(DateService dateParser) {
        this.dateParser = dateParser;
    }

    public Set<BucketMetadata> getResult() {
        return this.buckets;
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("ID")) {
            this.currentOwner = new CanonicalUser(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("DisplayName")) {
            this.currentOwner.setDisplayName(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("Bucket")) {
            this.buckets.add(new BucketMetadata(this.currentName, this.currentCreationDate, this.currentOwner));
        } else if (qName.equals("Name")) {
            this.currentName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("CreationDate")) {
            this.currentCreationDate = this.dateParser.iso8601DateOrSecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

