/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.collect.Maps;
import java.util.Map;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.http.functions.ParseSax;

public class MonitoringStateHandler
extends ParseSax.HandlerWithResult<Map<String, MonitoringState>> {
    private StringBuilder currentText = new StringBuilder();
    private Map<String, MonitoringState> monitoringState = Maps.newHashMap();
    private String instanceId;
    private MonitoringState state;

    public Map<String, MonitoringState> getResult() {
        return this.monitoringState;
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("instanceId")) {
            this.instanceId = this.currentText.toString().trim();
        } else if (qName.equals("state")) {
            this.state = MonitoringState.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("item")) {
            this.monitoringState.put(this.instanceId, this.state);
            this.instanceId = null;
            this.state = null;
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

