/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Map;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.xstream.MapConverter;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringKeyMapConverter
extends MapConverter {
    private static final Logger log = LoggerFactory.getLogger(StringKeyMapConverter.class);
    static final String VALID_XML_NODE_NAME_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_1234567890.";
    static final String VALID_XML_NODE_NAME_START_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_.";

    public StringKeyMapConverter(Mapper mapper) {
        super(mapper);
    }

    protected boolean isKeyValidForNodeName(String key) {
        return Identifiers.isValidToken((String)key, (String)VALID_XML_NODE_NAME_START_CHARS, (String)VALID_XML_NODE_NAME_CHARS);
    }

    public boolean canConvert(Class type) {
        return super.canConvert(type) || type.getName().equals(MutableMap.class.getName());
    }

    @Override
    protected void marshalEntry(HierarchicalStreamWriter writer, MarshallingContext context, Map.Entry entry) {
        if (entry.getKey() instanceof String) {
            this.marshalStringKey(writer, context, entry);
        } else {
            super.marshalEntry(writer, context, entry);
        }
    }

    protected void marshalStringKey(HierarchicalStreamWriter writer, MarshallingContext context, Map.Entry entry) {
        String entryNodeName;
        boolean useKeyAsNodeName;
        String key = (String)entry.getKey();
        boolean bl = useKeyAsNodeName = !key.equals(entryNodeName = this.getEntryNodeName()) && this.isKeyValidForNodeName(key);
        if (useKeyAsNodeName) {
            entryNodeName = key;
        }
        ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)entryNodeName, Map.Entry.class);
        if (!useKeyAsNodeName) {
            writer.addAttribute("key", key);
        }
        Object value = entry.getValue();
        if (entry.getValue() != null && this.isInlineableType(value.getClass())) {
            if (!(value instanceof String)) {
                writer.addAttribute("type", this.mapper().serializedClass(entry.getValue().getClass()));
            }
            if (entry.getValue().getClass().isEnum()) {
                writer.setValue(((Enum)entry.getValue()).name());
            } else {
                writer.setValue("" + entry.getValue());
            }
        } else {
            this.writeItem(entry.getValue(), context, writer);
        }
        writer.endNode();
    }

    protected boolean isInlineableType(Class<?> type) {
        return TypeCoercions.isPrimitiveOrBoxer(type) || String.class.equals(type) || type.isEnum();
    }

    @Override
    protected void unmarshalEntry(HierarchicalStreamReader reader, UnmarshallingContext context, Map map) {
        String key = reader.getNodeName();
        if (key.equals(this.getEntryNodeName())) {
            key = reader.getAttribute("key");
        }
        if (key == null) {
            super.unmarshalEntry(reader, context, map);
        } else {
            this.unmarshalStringKey(reader, context, map, key);
        }
    }

    protected void unmarshalStringKey(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, String key) {
        Object value;
        String type = reader.getAttribute("type");
        if (type == null && reader.hasMoreChildren()) {
            reader.moveDown();
            value = this.readItem(reader, context, map);
            reader.moveUp();
        } else {
            Class typeC = type != null ? this.mapper().realClass(type) : String.class;
            try {
                value = TypeCoercions.coerce((Object)reader.getValue(), typeC);
            }
            catch (Exception e) {
                log.warn("FAILED to coerce " + reader.getValue() + " to " + typeC + ": " + e);
                throw Exceptions.propagate((Throwable)e);
            }
        }
        map.put(key, value);
    }
}

