/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.http.executor;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.http.executor.HttpResponseImpl;

@Beta
public interface HttpResponse
extends Closeable {
    public int code();

    @Nullable
    public String reasonPhrase();

    public Multimap<String, String> headers();

    public long getContentLength();

    public InputStream getContent();

    @Beta
    public static class Builder {
        protected int code;
        protected String reasonPhrase;
        protected Multimap<String, String> headers = ArrayListMultimap.create();
        protected long contentLength = -1L;
        protected InputStream content;

        public Builder code(int val) {
            this.code = val;
            return this;
        }

        public Builder reasonPhrase(@Nullable String val) {
            this.reasonPhrase = val;
            return this;
        }

        public Builder headers(Multimap<String, String> val) {
            this.headers.putAll(val);
            return this;
        }

        public Builder headers(Map<String, String> val) {
            if (((Map)Preconditions.checkNotNull(val, (Object)"headers")).keySet().contains(null)) {
                throw new NullPointerException("Headers must not contain null key");
            }
            for (Map.Entry<String, String> entry : val.entrySet()) {
                this.header(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder header(String key, String val) {
            this.headers.put((Object)key, (Object)val);
            return this;
        }

        public Builder content(@Nullable InputStream val) {
            if (val != null) {
                this.contentLength = -1L;
                this.content = val;
            }
            return this;
        }

        public Builder content(@Nullable byte[] val) {
            if (val != null) {
                this.contentLength = val.length;
                this.content = new ByteArrayInputStream(val);
            }
            return this;
        }

        public HttpResponse build() {
            return new HttpResponseImpl(this);
        }
    }
}

