/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.brooklyn.camp.BasicCampPlatform;
import org.apache.brooklyn.camp.CampPlatform;
import org.apache.brooklyn.camp.spi.AbstractResource;
import org.apache.brooklyn.camp.spi.ApplicationComponent;
import org.apache.brooklyn.camp.spi.ApplicationComponentTemplate;
import org.apache.brooklyn.camp.spi.Assembly;
import org.apache.brooklyn.camp.spi.AssemblyTemplate;
import org.apache.brooklyn.camp.spi.PlatformComponent;
import org.apache.brooklyn.camp.spi.PlatformComponentTemplate;
import org.apache.brooklyn.camp.spi.PlatformRootSummary;
import org.apache.brooklyn.camp.spi.PlatformTransaction;
import org.apache.brooklyn.camp.spi.collection.AggregatingResourceLookup;
import org.apache.brooklyn.camp.spi.collection.ResourceLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatingCampPlatform
extends CampPlatform {
    private static final Logger log = LoggerFactory.getLogger(AggregatingCampPlatform.class);
    CampPlatform mainPlatform;
    List<CampPlatform> otherPlatformsToSearch = new ArrayList<CampPlatform>();

    protected AggregatingCampPlatform(PlatformRootSummary root) {
        this(root, new BasicCampPlatform(root));
    }

    public AggregatingCampPlatform(PlatformRootSummary root, CampPlatform platformWhereTransactionsOccur) {
        super(root);
        log.debug("Creating {} with main platform: {}", (Object)this, (Object)platformWhereTransactionsOccur);
        this.mainPlatform = platformWhereTransactionsOccur;
    }

    protected void addPlatform(CampPlatform platform) {
        log.debug("Adding child platform to {}: {}", (Object)this, (Object)platform);
        this.otherPlatformsToSearch.add(platform);
    }

    protected <T extends AbstractResource> ResourceLookup<T> aggregatingLookup(Function<CampPlatform, ResourceLookup<T>> lookupFunction) {
        ArrayList lookups = new ArrayList();
        lookups.add(lookupFunction.apply((Object)this.mainPlatform));
        for (CampPlatform p : this.otherPlatformsToSearch) {
            lookups.add(lookupFunction.apply((Object)p));
        }
        return AggregatingResourceLookup.of(lookups);
    }

    @Override
    public ResourceLookup<PlatformComponentTemplate> platformComponentTemplates() {
        return this.aggregatingLookup(new Function<CampPlatform, ResourceLookup<PlatformComponentTemplate>>(){

            public ResourceLookup<PlatformComponentTemplate> apply(@Nullable CampPlatform input) {
                return input.platformComponentTemplates();
            }
        });
    }

    @Override
    public ResourceLookup<ApplicationComponentTemplate> applicationComponentTemplates() {
        return this.aggregatingLookup(new Function<CampPlatform, ResourceLookup<ApplicationComponentTemplate>>(){

            public ResourceLookup<ApplicationComponentTemplate> apply(@Nullable CampPlatform input) {
                return input.applicationComponentTemplates();
            }
        });
    }

    @Override
    public ResourceLookup<AssemblyTemplate> assemblyTemplates() {
        return this.aggregatingLookup(new Function<CampPlatform, ResourceLookup<AssemblyTemplate>>(){

            public ResourceLookup<AssemblyTemplate> apply(@Nullable CampPlatform input) {
                return input.assemblyTemplates();
            }
        });
    }

    @Override
    public ResourceLookup<PlatformComponent> platformComponents() {
        return this.aggregatingLookup(new Function<CampPlatform, ResourceLookup<PlatformComponent>>(){

            public ResourceLookup<PlatformComponent> apply(@Nullable CampPlatform input) {
                return input.platformComponents();
            }
        });
    }

    @Override
    public ResourceLookup<ApplicationComponent> applicationComponents() {
        return this.aggregatingLookup(new Function<CampPlatform, ResourceLookup<ApplicationComponent>>(){

            public ResourceLookup<ApplicationComponent> apply(@Nullable CampPlatform input) {
                return input.applicationComponents();
            }
        });
    }

    @Override
    public ResourceLookup<Assembly> assemblies() {
        return this.aggregatingLookup(new Function<CampPlatform, ResourceLookup<Assembly>>(){

            public ResourceLookup<Assembly> apply(@Nullable CampPlatform input) {
                return input.assemblies();
            }
        });
    }

    @Override
    public PlatformTransaction transaction() {
        return this.mainPlatform.transaction();
    }
}

