/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloudstorage.domain.BucketAccessControls;
import org.jclouds.googlecloudstorage.domain.templates.BucketAccessControlsTemplate;
import org.jclouds.http.HttpResponse;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Consumes(value={"application/json"})
public interface BucketAccessControlsApi {
    @Named(value="BucketAccessControls:get")
    @GET
    @Path(value="/b/{bucket}/acl/{entity}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public BucketAccessControls getBucketAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="entity") String var2);

    @Named(value="BucketAccessControls:insert")
    @POST
    @Path(value="/b/{bucket}/acl")
    public BucketAccessControls createBucketAccessControls(@PathParam(value="bucket") String var1, @BinderParam(value=BindToJsonPayload.class) BucketAccessControlsTemplate var2);

    @Named(value="BucketAccessControls:delete")
    @DELETE
    @Path(value="/b/{bucket}/acl/{entity}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public HttpResponse deleteBucketAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="entity") String var2);

    @Named(value="BucketAccessControls:list")
    @GET
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/acl")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    @SelectJson(value={"items"})
    public List<BucketAccessControls> listBucketAccessControls(@PathParam(value="bucket") String var1);

    @Named(value="BucketAccessControls:update")
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/acl/{entity}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public BucketAccessControls updateBucketAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="entity") String var2, @BinderParam(value=BindToJsonPayload.class) BucketAccessControlsTemplate var3);

    @Named(value="BucketAccessControls:patch")
    @PATCH
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/acl/{entity}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public BucketAccessControls patchBucketAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="entity") String var2, @BinderParam(value=BindToJsonPayload.class) BucketAccessControlsTemplate var3);
}

