/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v1_1.suppliers;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.assistedinject.Assisted;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import org.jclouds.location.suppliers.ImplicitRegionIdSupplier;
import org.jclouds.openstack.keystone.v1_1.domain.Auth;
import org.jclouds.openstack.keystone.v1_1.domain.Endpoint;
import org.jclouds.openstack.keystone.v1_1.functions.EndpointToRegion;

public class V1DefaultRegionIdSupplier
implements ImplicitRegionIdSupplier {
    private final Supplier<Auth> auth;
    private final EndpointToRegion endpointToRegion;
    private final String apiType;

    @Inject
    public V1DefaultRegionIdSupplier(Supplier<Auth> auth, EndpointToRegion endpointToRegion, @Assisted(value="apiType") String apiType) {
        this.auth = auth;
        this.endpointToRegion = endpointToRegion;
        this.apiType = apiType;
    }

    public String get() {
        Auth authResponse = (Auth)this.auth.get();
        Collection endpointsForService = authResponse.getServiceCatalog().get((Object)this.apiType);
        Optional defaultEndpoint = Iterables.tryFind((Iterable)endpointsForService, (Predicate)new Predicate<Endpoint>(){

            public boolean apply(Endpoint in) {
                return in.isV1Default();
            }
        });
        return (String)this.endpointToRegion.apply((Endpoint)defaultEndpoint.or((Object)((Endpoint)Iterables.get((Iterable)endpointsForService, (int)0))));
    }

    public String toString() {
        return "defaultRegionIdFor(" + this.apiType + ")";
    }

    public static interface Factory {
        public ImplicitRegionIdSupplier createForApiType(@Assisted(value="apiType") String var1) throws NoSuchElementException;
    }
}

