/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.filter;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.rest.filter.BrooklynSecurityProviderFilterHelper;
import org.apache.brooklyn.rest.filter.BrooklynSecurityProviderFilterJavax;
import org.apache.brooklyn.rest.security.provider.SecurityProvider;
import org.apache.brooklyn.util.text.Strings;
import org.eclipse.jetty.http.HttpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=100)
public class BrooklynSecurityProviderFilterJersey
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(BrooklynSecurityProviderFilterJersey.class);
    public static final String LOGIN_PAGE_HEADER = "X_BROOKLYN_LOGIN_PAGE";
    private final Set<String> headersToForward = ImmutableSet.of((Object)"WWW-Authenticate", (Object)"X_BROOKLYN_UNAUTHORIZED_MESSAGE");
    @Context
    HttpServletRequest webRequest;
    @Context
    private ContextResolver<ManagementContext> mgmtC;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        log.trace("BrooklynSecurityProviderFilterJersey.filter {}", (Object)requestContext);
        ManagementContext mgmt = (ManagementContext)this.mgmtC.getContext(ManagementContext.class);
        try {
            new BrooklynSecurityProviderFilterHelper().run(this.webRequest, mgmt);
        }
        catch (SecurityProvider.SecurityProviderDeniedAuthentication e) {
            MultivaluedMap responseHeaders;
            Response rin = e.getResponse();
            if (rin == null) {
                rin = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (rin.getStatus() == Response.Status.FOUND.getStatusCode()) {
                String location = rin.getHeaderString(HttpHeader.LOCATION.asString());
                if (location != null) {
                    log.trace("Redirect to {} for authentication", (Object)location);
                    UriBuilder uriBuilder = UriBuilder.fromPath((String)location);
                    rin = Response.temporaryRedirect((URI)uriBuilder.build(new Object[0])).entity((Object)("Authentication is required at " + location)).build();
                } else {
                    log.trace("Unauthorized");
                    rin = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication is required").build();
                }
            }
            if (rin.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode() && Strings.isNonBlank((CharSequence)((CharSequence)mgmt.getConfig().getConfig(BrooklynSecurityProviderFilterJavax.LOGIN_FORM)))) {
                rin = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication is required").header(LOGIN_PAGE_HEADER, mgmt.getConfig().getConfig(BrooklynSecurityProviderFilterJavax.LOGIN_FORM)).build();
            }
            if ((responseHeaders = e.getResponse().getHeaders()) != null && !responseHeaders.isEmpty()) {
                for (String headerKey : this.headersToForward) {
                    if (!responseHeaders.containsKey((Object)headerKey)) continue;
                    rin = Response.fromResponse((Response)rin).header(headerKey, (Object)((List)responseHeaders.get((Object)headerKey)).stream().map(Object::toString).collect(Collectors.joining(", "))).build();
                }
            }
            requestContext.abortWith(rin);
        }
    }
}

