/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.domain.templates;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jclouds.googlecloudstorage.domain.GoogleCloudStorageObject;
import org.jclouds.googlecloudstorage.domain.templates.AutoValue_ComposeObjectTemplate;
import org.jclouds.googlecloudstorage.domain.templates.AutoValue_ComposeObjectTemplate_SourceObject;
import org.jclouds.googlecloudstorage.domain.templates.AutoValue_ComposeObjectTemplate_SourceObject_ObjectPreconditions;
import org.jclouds.googlecloudstorage.domain.templates.ObjectTemplate;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class ComposeObjectTemplate {
    public abstract List<SourceObject> sourceObjects();

    public abstract ObjectTemplate destination();

    @SerializedNames(value={"sourceObjects", "destination"})
    public static ComposeObjectTemplate create(List<SourceObject> sourceObjects, ObjectTemplate destination) {
        return new AutoValue_ComposeObjectTemplate(sourceObjects, destination);
    }

    public static Builder builder() {
        return new Builder();
    }

    ComposeObjectTemplate() {
    }

    public static class Builder {
        private ImmutableList<SourceObject> sourceObjects;
        private ObjectTemplate destination;

        Builder() {
        }

        public Builder fromGoogleCloudStorageObject(Collection<GoogleCloudStorageObject> objects) {
            ImmutableList.Builder sourceObjects = new ImmutableList.Builder();
            for (GoogleCloudStorageObject obj : objects) {
                sourceObjects.add((Object)SourceObject.createWithPrecondition(obj.name(), obj.generation(), obj.generation()));
            }
            this.sourceObjects = sourceObjects.build();
            return this;
        }

        public Builder fromNames(List<String> SourceObjectNames) {
            ArrayList<SourceObject> sourceObjects = new ArrayList<SourceObject>();
            for (String name : SourceObjectNames) {
                sourceObjects.add(SourceObject.nameOnly(name));
            }
            this.sourceObjects = ImmutableList.copyOf(sourceObjects);
            return this;
        }

        public Builder destination(ObjectTemplate destination) {
            Preconditions.checkNotNull((Object)destination, (Object)"destination");
            this.destination = destination;
            return this;
        }

        public ComposeObjectTemplate build() {
            return ComposeObjectTemplate.create(this.sourceObjects, this.destination);
        }
    }

    public static abstract class SourceObject {
        public abstract String name();

        @Nullable
        public abstract Long generation();

        @Nullable
        public abstract ObjectPreconditions objectPreconditions();

        public static SourceObject nameOnly(String name) {
            return SourceObject.create(name, null, null);
        }

        public static SourceObject createWithPrecondition(String name, Long generation, Long objectPreconditions) {
            return SourceObject.create(name, generation, ObjectPreconditions.create(objectPreconditions));
        }

        @SerializedNames(value={"name", "generation", "objectPreconditions"})
        public static SourceObject create(String name, @Nullable Long generation, @Nullable ObjectPreconditions objectPreconditions) {
            return new AutoValue_ComposeObjectTemplate_SourceObject(name, generation, objectPreconditions);
        }

        SourceObject() {
        }

        public static abstract class ObjectPreconditions {
            public abstract long ifGenerationMatch();

            @SerializedNames(value={"ifGenerationMatch"})
            public static ObjectPreconditions create(long ifGenerationMatch) {
                return new AutoValue_ComposeObjectTemplate_SourceObject_ObjectPreconditions(ifGenerationMatch);
            }

            ObjectPreconditions() {
            }
        }
    }
}

