/*
 * Camel EndpointConfiguration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.olingo4;

import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

/**
 * Camel endpoint configuration for {@link org.apache.camel.component.olingo4.api.Olingo4App}.
 */
@ApiParams(apiName = "DEFAULT", 
           description = "Olingo4 Client Api Interface",
           apiMethods = {@ApiMethod(methodName = "action", description="Calls a OData action", signatures={"void action(org.apache.olingo.commons.api.edm.Edm edm, String resourcePath, java.util.Map<String, String> endpointHttpHeaders, Object data, org.apache.camel.component.olingo4.api.Olingo4ResponseHandler responseHandler)"}), @ApiMethod(methodName = "batch", description="Executes a batch request", signatures={"void batch(org.apache.olingo.commons.api.edm.Edm edm, java.util.Map<String, String> endpointHttpHeaders, Object data, org.apache.camel.component.olingo4.api.Olingo4ResponseHandler<java.util.List<org.apache.camel.component.olingo4.api.batch.Olingo4BatchResponse>> responseHandler)"}), @ApiMethod(methodName = "create", description="Creates a new OData resource", signatures={"void create(org.apache.olingo.commons.api.edm.Edm edm, String resourcePath, java.util.Map<String, String> endpointHttpHeaders, Object data, org.apache.camel.component.olingo4.api.Olingo4ResponseHandler responseHandler)"}), @ApiMethod(methodName = "delete", description="Deletes an OData resource and invokes callback with org", signatures={"void delete(String resourcePath, java.util.Map<String, String> endpointHttpHeaders, org.apache.camel.component.olingo4.api.Olingo4ResponseHandler<org.apache.olingo.commons.api.http.HttpStatusCode> responseHandler)"}), @ApiMethod(methodName = "merge", description="Patches/merges an OData resource using HTTP MERGE", signatures={"void merge(org.apache.olingo.commons.api.edm.Edm edm, String resourcePath, java.util.Map<String, String> endpointHttpHeaders, Object data, org.apache.camel.component.olingo4.api.Olingo4ResponseHandler responseHandler)"}), @ApiMethod(methodName = "patch", description="Patches/merges an OData resource using HTTP PATCH", signatures={"void patch(org.apache.olingo.commons.api.edm.Edm edm, String resourcePath, java.util.Map<String, String> endpointHttpHeaders, Object data, org.apache.camel.component.olingo4.api.Olingo4ResponseHandler responseHandler)"}), @ApiMethod(methodName = "read", description="Reads an OData resource and invokes callback with appropriate result", signatures={"void read(org.apache.olingo.commons.api.edm.Edm edm, String resourcePath, java.util.Map<String, String> queryParams, java.util.Map<String, String> endpointHttpHeaders, org.apache.camel.component.olingo4.api.Olingo4ResponseHandler responseHandler)"}), @ApiMethod(methodName = "update", description="Updates an OData resource", signatures={"void update(org.apache.olingo.commons.api.edm.Edm edm, String resourcePath, java.util.Map<String, String> endpointHttpHeaders, Object data, org.apache.camel.component.olingo4.api.Olingo4ResponseHandler responseHandler)"}), @ApiMethod(methodName = "uread", description="Reads an OData resource and invokes callback with the unparsed input stream", signatures={"void uread(org.apache.olingo.commons.api.edm.Edm edm, String resourcePath, java.util.Map<String, String> queryParams, java.util.Map<String, String> endpointHttpHeaders, org.apache.camel.component.olingo4.api.Olingo4ResponseHandler<java.io.InputStream> responseHandler)"})}, aliases = {})
@UriParams
@Configurer(extended = true)
public final class Olingo4AppEndpointConfiguration extends Olingo4Configuration {
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "action", description="Action data"), @ApiMethod(methodName = "batch", description="Ordered org.apache.camel.component.olingo4.api.batch.Olingo4BatchRequest list"), @ApiMethod(methodName = "create", description="Request data"), @ApiMethod(methodName = "merge", description="Patch/merge data"), @ApiMethod(methodName = "patch", description="Patch/merge data"), @ApiMethod(methodName = "update", description="Updated data")})
    private Object data;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "action", description="Service Edm"), @ApiMethod(methodName = "batch", description="Service Edm"), @ApiMethod(methodName = "create", description="Service Edm"), @ApiMethod(methodName = "merge", description="Service Edm"), @ApiMethod(methodName = "patch", description="Service Edm"), @ApiMethod(methodName = "read", description="Service Edm, read from calling read(null, $metdata, null, responseHandler)"), @ApiMethod(methodName = "update", description="Service Edm"), @ApiMethod(methodName = "uread", description="Service Edm, read from calling read(null, $metdata, null, responseHandler)")})
    private org.apache.olingo.commons.api.edm.Edm edm;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "action", description="HTTP Headers to add/override the component versions"), @ApiMethod(methodName = "batch", description="HTTP Headers to add/override the component versions"), @ApiMethod(methodName = "create", description="HTTP Headers to add/override the component versions"), @ApiMethod(methodName = "delete", description="HTTP Headers to add/override the component versions"), @ApiMethod(methodName = "merge", description="HTTP Headers to add/override the component versions"), @ApiMethod(methodName = "patch", description="HTTP Headers to add/override the component versions"), @ApiMethod(methodName = "read", description="HTTP Headers to add/override the component versions"), @ApiMethod(methodName = "update", description="HTTP Headers to add/override the component versions"), @ApiMethod(methodName = "uread", description="HTTP Headers to add/override the component versions")})
    private java.util.Map<String, String> endpointHttpHeaders;
    @UriParam
    @ApiParam(optional = false, apiMethods = {})
    private java.lang.String keyPredicate;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "read", description="OData query params http://docs.oasis-open.org/odata/odata/v4.0/odata-v4.0-part1-protocol.html#_Toc453752288"), @ApiMethod(methodName = "uread", description="OData query params http://docs.oasis-open.org/odata/odata/v4.0/odata-v4.0-part1-protocol.html#_Toc453752288")})
    private java.util.Map<String, String> queryParams;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "action", description="Resource path to action"), @ApiMethod(methodName = "create", description="Resource path to create"), @ApiMethod(methodName = "delete", description="Resource path for Entry"), @ApiMethod(methodName = "merge", description="Resource path to update"), @ApiMethod(methodName = "patch", description="Resource path to update"), @ApiMethod(methodName = "read", description="OData Resource path"), @ApiMethod(methodName = "update", description="Resource path to update"), @ApiMethod(methodName = "uread", description="OData Resource path")})
    private String resourcePath;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "action", description="Org.apache.olingo.client.api.domain.ClientEntity callback handler"), @ApiMethod(methodName = "batch", description="Callback handler"), @ApiMethod(methodName = "create", description="Callback handler"), @ApiMethod(methodName = "delete", description="Org.apache.olingo.commons.api.http.HttpStatusCode callback handler"), @ApiMethod(methodName = "merge", description="Org.apache.olingo.client.api.domain.ClientEntity callback handler"), @ApiMethod(methodName = "patch", description="Org.apache.olingo.client.api.domain.ClientEntity callback handler"), @ApiMethod(methodName = "read", description="Callback handler"), @ApiMethod(methodName = "update", description="Org.apache.olingo.client.api.domain.ClientEntity callback handler"), @ApiMethod(methodName = "uread", description="Callback handler")})
    private org.apache.camel.component.olingo4.api.Olingo4ResponseHandler responseHandler;

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public org.apache.olingo.commons.api.edm.Edm getEdm() {
        return edm;
    }

    public void setEdm(org.apache.olingo.commons.api.edm.Edm edm) {
        this.edm = edm;
    }

    public java.util.Map<String, String> getEndpointHttpHeaders() {
        return endpointHttpHeaders;
    }

    public void setEndpointHttpHeaders(java.util.Map<String, String> endpointHttpHeaders) {
        this.endpointHttpHeaders = endpointHttpHeaders;
    }

    public java.lang.String getKeyPredicate() {
        return keyPredicate;
    }

    public void setKeyPredicate(java.lang.String keyPredicate) {
        this.keyPredicate = keyPredicate;
    }

    public java.util.Map<String, String> getQueryParams() {
        return queryParams;
    }

    public void setQueryParams(java.util.Map<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public String getResourcePath() {
        return resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public org.apache.camel.component.olingo4.api.Olingo4ResponseHandler getResponseHandler() {
        return responseHandler;
    }

    public void setResponseHandler(org.apache.camel.component.olingo4.api.Olingo4ResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }
}
