/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.netty.http.NettyHttpComponent;

/**
 * Netty HTTP server and client using the Netty 4.x.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface NettyHttpComponentBuilderFactory {

    /**
     * Netty HTTP (camel-netty-http)
     * Netty HTTP server and client using the Netty 4.x.
     * 
     * Category: networking,http
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-netty-http
     * 
     * @return the dsl builder
     */
    static NettyHttpComponentBuilder nettyHttp() {
        return new NettyHttpComponentBuilderImpl();
    }

    /**
     * Builder for the Netty HTTP component.
     */
    interface NettyHttpComponentBuilder extends ComponentBuilder<NettyHttpComponent> {
    
        /**
         * To use the NettyConfiguration as configuration when creating
         * endpoints.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.NettyConfiguration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder configuration(org.apache.camel.component.netty.NettyConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        
        /**
         * Whether or not to disconnect(close) from Netty Channel right after
         * use.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder disconnect(boolean disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
    
        
        /**
         * Setting to ensure socket is not closed due to inactivity.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param keepAlive the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder keepAlive(boolean keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
    
        
        /**
         * Setting to facilitate socket multiplexing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reuseAddress the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder reuseAddress(boolean reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
    
        
        /**
         * This option allows producers and consumers (in client mode) to reuse
         * the same Netty Channel for the lifecycle of processing the Exchange.
         * This is useful if you need to call a server multiple times in a Camel
         * route and want to use the same network connection. When using this,
         * the channel is not returned to the connection pool until the Exchange
         * is done; or disconnected if the disconnect option is set to true. The
         * reused Channel is stored on the Exchange as an exchange property with
         * the key CamelNettyChannel which allows you to obtain the channel
         * during routing and use it as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reuseChannel the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder reuseChannel(boolean reuseChannel) {
            doSetProperty("reuseChannel", reuseChannel);
            return this;
        }
    
        
        /**
         * Setting to set endpoint as one-way (false) or request-response
         * (true).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder sync(boolean sync) {
            doSetProperty("sync", sync);
            return this;
        }
    
        
        /**
         * Setting to improve TCP protocol performance.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param tcpNoDelay the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder tcpNoDelay(boolean tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
    
        
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    
        
        /**
         * If the clientMode is true, netty consumer will connect the address as
         * a TCP client.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param clientMode the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder clientMode(boolean clientMode) {
            doSetProperty("clientMode", clientMode);
            return this;
        }
    
        
        /**
         * If enabled and an Exchange failed processing on the consumer side the
         * response's body won't contain the exception's stack trace.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param muteException the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder muteException(boolean muteException) {
            doSetProperty("muteException", muteException);
            return this;
        }
    
        
        /**
         * Used only in clientMode in consumer, the consumer will attempt to
         * reconnect on disconnection if this is enabled.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param reconnect the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder reconnect(boolean reconnect) {
            doSetProperty("reconnect", reconnect);
            return this;
        }
    
        
        /**
         * Used if reconnect and clientMode is enabled. The interval in milli
         * seconds to attempt reconnection.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: consumer
         * 
         * @param reconnectInterval the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder reconnectInterval(int reconnectInterval) {
            doSetProperty("reconnectInterval", reconnectInterval);
            return this;
        }
    
        /**
         * Allows to configure a backlog for netty consumer (server). Note the
         * backlog is just a best effort depending on the OS. Setting this
         * option to a value such as 200, 500 or 1000, tells the TCP stack how
         * long the accept queue can be If this option is not configured, then
         * the backlog depends on OS setting.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param backlog the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder backlog(int backlog) {
            doSetProperty("backlog", backlog);
            return this;
        }
    
        
        /**
         * When netty works on nio mode, it uses default bossCount parameter
         * from Netty, which is 1. User can use this option to override the
         * default bossCount from Netty.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer (advanced)
         * 
         * @param bossCount the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder bossCount(int bossCount) {
            doSetProperty("bossCount", bossCount);
            return this;
        }
    
        /**
         * Set the BossGroup which could be used for handling the new connection
         * of the server side across the NettyEndpoint.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param bossGroup the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder bossGroup(io.netty.channel.EventLoopGroup bossGroup) {
            doSetProperty("bossGroup", bossGroup);
            return this;
        }
    
        
        /**
         * Setting to choose Multicast over UDP.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param broadcast the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder broadcast(boolean broadcast) {
            doSetProperty("broadcast", broadcast);
            return this;
        }
    
        
        /**
         * If sync is enabled then this option dictates NettyConsumer if it
         * should disconnect where there is no reply to send back.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param disconnectOnNoReply the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder disconnectOnNoReply(boolean disconnectOnNoReply) {
            doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }
    
        /**
         * To use the given custom EventExecutorGroup.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.util.concurrent.EventExecutorGroup&lt;/code&gt;
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param executorService the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder executorService(io.netty.util.concurrent.EventExecutorGroup executorService) {
            doSetProperty("executorService", executorService);
            return this;
        }
    
        /**
         * Sets a maximum thread pool size for the netty consumer ordered thread
         * pool. The default size is 2 x cpu_core plus 1. Setting this value to
         * eg 10 will then use 10 threads unless 2 x cpu_core plus 1 is a higher
         * value, which then will override and be used. For example if there are
         * 8 cores, then the consumer thread pool will be 17. This thread pool
         * is used to route messages received from Netty by Camel. We use a
         * separate thread pool to ensure ordering of messages and also in case
         * some messages will block, then nettys worker threads (event loop)
         * wont be affected.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param maximumPoolSize the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder maximumPoolSize(int maximumPoolSize) {
            doSetProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }
    
        /**
         * To use a custom NettyServerBootstrapFactory.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.NettyServerBootstrapFactory&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param nettyServerBootstrapFactory the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder nettyServerBootstrapFactory(org.apache.camel.component.netty.NettyServerBootstrapFactory nettyServerBootstrapFactory) {
            doSetProperty("nettyServerBootstrapFactory", nettyServerBootstrapFactory);
            return this;
        }
    
        /**
         * When using UDP then this option can be used to specify a network
         * interface by its name, such as eth0 to join a multicast group.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param networkInterface the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder networkInterface(java.lang.String networkInterface) {
            doSetProperty("networkInterface", networkInterface);
            return this;
        }
    
        
        /**
         * If sync is enabled this option dictates NettyConsumer which logging
         * level to use when logging a there is no reply to send back.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: consumer (advanced)
         * 
         * @param noReplyLogLevel the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder noReplyLogLevel(org.apache.camel.LoggingLevel noReplyLogLevel) {
            doSetProperty("noReplyLogLevel", noReplyLogLevel);
            return this;
        }
    
        
        /**
         * If the server (NettyConsumer) catches an
         * java.nio.channels.ClosedChannelException then its logged using this
         * logging level. This is used to avoid logging the closed channel
         * exceptions, as clients can disconnect abruptly and then cause a flood
         * of closed exceptions in the Netty server.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: DEBUG
         * Group: consumer (advanced)
         * 
         * @param serverClosedChannelExceptionCaughtLogLevel the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder serverClosedChannelExceptionCaughtLogLevel(org.apache.camel.LoggingLevel serverClosedChannelExceptionCaughtLogLevel) {
            doSetProperty("serverClosedChannelExceptionCaughtLogLevel", serverClosedChannelExceptionCaughtLogLevel);
            return this;
        }
    
        
        /**
         * If the server (NettyConsumer) catches an exception then its logged
         * using this logging level.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: consumer (advanced)
         * 
         * @param serverExceptionCaughtLogLevel the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder serverExceptionCaughtLogLevel(org.apache.camel.LoggingLevel serverExceptionCaughtLogLevel) {
            doSetProperty("serverExceptionCaughtLogLevel", serverExceptionCaughtLogLevel);
            return this;
        }
    
        /**
         * To use a custom ServerInitializerFactory.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.ServerInitializerFactory&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param serverInitializerFactory the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder serverInitializerFactory(org.apache.camel.component.netty.ServerInitializerFactory serverInitializerFactory) {
            doSetProperty("serverInitializerFactory", serverInitializerFactory);
            return this;
        }
    
        
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param usingExecutorService the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder usingExecutorService(boolean usingExecutorService) {
            doSetProperty("usingExecutorService", usingExecutorService);
            return this;
        }
    
        
        /**
         * Time to wait for a socket connection to be available. Value is in
         * milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: producer
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder connectTimeout(int connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        /**
         * Allows to use a timeout for the Netty producer when calling a remote
         * server. By default no timeout is in use. The value is in milli
         * seconds, so eg 30000 is 30 seconds. The requestTimeout is using
         * Netty's ReadTimeoutHandler to trigger the timeout.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder requestTimeout(long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
    
        /**
         * To use a custom ClientInitializerFactory.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.ClientInitializerFactory&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param clientInitializerFactory the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder clientInitializerFactory(org.apache.camel.component.netty.ClientInitializerFactory clientInitializerFactory) {
            doSetProperty("clientInitializerFactory", clientInitializerFactory);
            return this;
        }
    
        /**
         * To use a custom correlation manager to manage how request and reply
         * messages are mapped when using request/reply with the netty producer.
         * This should only be used if you have a way to map requests together
         * with replies such as if there is correlation ids in both the request
         * and reply messages. This can be used if you want to multiplex
         * concurrent messages on the same channel (aka connection) in netty.
         * When doing this you must have a way to correlate the request and
         * reply messages so you can store the right reply on the inflight Camel
         * Exchange before its continued routed. We recommend extending the
         * TimeoutCorrelationManagerSupport when you build custom correlation
         * managers. This provides support for timeout and other complexities
         * you otherwise would need to implement as well. See also the
         * producerPoolEnabled option for more details.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.NettyCamelStateCorrelationManager&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param correlationManager the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder correlationManager(org.apache.camel.component.netty.NettyCamelStateCorrelationManager correlationManager) {
            doSetProperty("correlationManager", correlationManager);
            return this;
        }
    
        
        /**
         * Channels can be lazily created to avoid exceptions, if the remote
         * server is not up and running when the Camel producer is started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param lazyChannelCreation the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder lazyChannelCreation(boolean lazyChannelCreation) {
            doSetProperty("lazyChannelCreation", lazyChannelCreation);
            return this;
        }
    
        
        /**
         * Sets the value for the blockWhenExhausted configuration attribute. It
         * determines whether to block when the borrowObject() method is invoked
         * when the pool is exhausted (the maximum number of active objects has
         * been reached).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param producerPoolBlockWhenExhausted the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder producerPoolBlockWhenExhausted(boolean producerPoolBlockWhenExhausted) {
            doSetProperty("producerPoolBlockWhenExhausted", producerPoolBlockWhenExhausted);
            return this;
        }
    
        
        /**
         * Whether producer pool is enabled or not. Important: If you turn this
         * off then a single shared connection is used for the producer, also if
         * you are doing request/reply. That means there is a potential issue
         * with interleaved responses if replies comes back out-of-order.
         * Therefore you need to have a correlation id in both the request and
         * reply messages so you can properly correlate the replies to the Camel
         * callback that is responsible for continue processing the message in
         * Camel. To do this you need to implement
         * NettyCamelStateCorrelationManager as correlation manager and
         * configure it via the correlationManager option. See also the
         * correlationManager option for more details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param producerPoolEnabled the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder producerPoolEnabled(boolean producerPoolEnabled) {
            doSetProperty("producerPoolEnabled", producerPoolEnabled);
            return this;
        }
    
        
        /**
         * Sets the cap on the number of idle instances in the pool.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: producer (advanced)
         * 
         * @param producerPoolMaxIdle the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder producerPoolMaxIdle(int producerPoolMaxIdle) {
            doSetProperty("producerPoolMaxIdle", producerPoolMaxIdle);
            return this;
        }
    
        
        /**
         * Sets the cap on the number of objects that can be allocated by the
         * pool (checked out to clients, or idle awaiting checkout) at a given
         * time. Use a negative value for no limit. Be careful to not set this
         * value too low (such as 1) as the pool must have space to create a
         * producer such as when performing retries. Be mindful that the option
         * producerPoolBlockWhenExhausted is default true, and the pool will
         * then block when there is no space, which can lead to the application
         * to hang.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer (advanced)
         * 
         * @param producerPoolMaxTotal the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder producerPoolMaxTotal(int producerPoolMaxTotal) {
            doSetProperty("producerPoolMaxTotal", producerPoolMaxTotal);
            return this;
        }
    
        
        /**
         * Sets the maximum duration (value in millis) the borrowObject() method
         * should block before throwing an exception when the pool is exhausted
         * and producerPoolBlockWhenExhausted is true. When less than 0, the
         * borrowObject() method may block indefinitely.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer (advanced)
         * 
         * @param producerPoolMaxWait the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder producerPoolMaxWait(long producerPoolMaxWait) {
            doSetProperty("producerPoolMaxWait", producerPoolMaxWait);
            return this;
        }
    
        
        /**
         * Sets the minimum amount of time (value in millis) an object may sit
         * idle in the pool before it is eligible for eviction by the idle
         * object evictor.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: producer (advanced)
         * 
         * @param producerPoolMinEvictableIdle the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder producerPoolMinEvictableIdle(long producerPoolMinEvictableIdle) {
            doSetProperty("producerPoolMinEvictableIdle", producerPoolMinEvictableIdle);
            return this;
        }
    
        /**
         * Sets the minimum number of instances allowed in the producer pool
         * before the evictor thread (if active) spawns new objects.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param producerPoolMinIdle the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder producerPoolMinIdle(int producerPoolMinIdle) {
            doSetProperty("producerPoolMinIdle", producerPoolMinIdle);
            return this;
        }
    
        
        /**
         * This option supports connection less udp sending which is a real fire
         * and forget. A connected udp send receive the PortUnreachableException
         * if no one is listen on the receiving port.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param udpConnectionlessSending the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder udpConnectionlessSending(boolean udpConnectionlessSending) {
            doSetProperty("udpConnectionlessSending", udpConnectionlessSending);
            return this;
        }
    
        
        /**
         * If the useByteBuf is true, netty producer will turn the message body
         * into ByteBuf before sending it out.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param useByteBuf the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder useByteBuf(boolean useByteBuf) {
            doSetProperty("useByteBuf", useByteBuf);
            return this;
        }
    
        
        /**
         * Only used for TCP when transferExchange is true. When set to true,
         * serializable objects in headers and properties will be added to the
         * exchange. Otherwise Camel will exclude any non-serializable objects
         * and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder allowSerializedHeaders(boolean allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * To use an explicit ChannelGroup.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.group.ChannelGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param channelGroup the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder channelGroup(io.netty.channel.group.ChannelGroup channelGroup) {
            doSetProperty("channelGroup", channelGroup);
            return this;
        }
    
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * headers.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
    
        
        /**
         * Whether to use native transport instead of NIO. Native transport
         * takes advantage of the host operating system and is only supported on
         * some platforms. You need to add the netty JAR for the host operating
         * system you are using. See more details at:
         * http://netty.io/wiki/native-transports.html.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param nativeTransport the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder nativeTransport(boolean nativeTransport) {
            doSetProperty("nativeTransport", nativeTransport);
            return this;
        }
    
        /**
         * To use a custom
         * org.apache.camel.component.netty.http.NettyHttpBinding for binding
         * to/from Netty and Camel Message API.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpBinding&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nettyHttpBinding the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder nettyHttpBinding(org.apache.camel.component.netty.http.NettyHttpBinding nettyHttpBinding) {
            doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }
    
        /**
         * Allows to configure additional netty options using option. as prefix.
         * For example option.child.keepAlive=false. See the Netty documentation
         * for possible options that can be used. This is a multi-value option
         * with prefix: option.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param options the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder options(java.util.Map<java.lang.String, java.lang.Object> options) {
            doSetProperty("options", options);
            return this;
        }
    
        
        /**
         * The TCP/UDP buffer sizes to be used during inbound communication.
         * Size is bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder receiveBufferSize(int receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
    
        /**
         * Configures the buffer size predictor. See details at Jetty
         * documentation and this mail thread.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param receiveBufferSizePredictor the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder receiveBufferSizePredictor(int receiveBufferSizePredictor) {
            doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }
    
        
        /**
         * The TCP/UDP buffer sizes to be used during outbound communication.
         * Size is bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder sendBufferSize(int sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
    
        
        /**
         * Shutdown await timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param shutdownTimeout the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder shutdownTimeout(int shutdownTimeout) {
            doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }
    
        
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder transferExchange(boolean transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
    
        
        /**
         * For UDP only. If enabled the using byte array codec instead of Java
         * serialization protocol.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param udpByteArrayCodec the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder udpByteArrayCodec(boolean udpByteArrayCodec) {
            doSetProperty("udpByteArrayCodec", udpByteArrayCodec);
            return this;
        }
    
        /**
         * Path to unix domain socket to use instead of inet socket. Host and
         * port parameters will not be used, however required. It is ok to set
         * dummy values for them. Must be used with nativeTransport=true and
         * clientMode=false.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param unixDomainSocketPath the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder unixDomainSocketPath(java.lang.String unixDomainSocketPath) {
            doSetProperty("unixDomainSocketPath", unixDomainSocketPath);
            return this;
        }
    
        /**
         * When netty works on nio mode, it uses default workerCount parameter
         * from Netty (which is cpu_core_threads x 2). User can use this option
         * to override the default workerCount from Netty.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerCount the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder workerCount(int workerCount) {
            doSetProperty("workerCount", workerCount);
            return this;
        }
    
        /**
         * To use a explicit EventLoopGroup as the boss thread pool. For example
         * to share a thread pool with multiple consumers or producers. By
         * default each consumer or producer has their own worker pool with 2 x
         * cpu count core threads.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerGroup the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder workerGroup(io.netty.channel.EventLoopGroup workerGroup) {
            doSetProperty("workerGroup", workerGroup);
            return this;
        }
    
        
        /**
         * The netty component installs a default codec if both, encoder/decoder
         * is null and textline is false. Setting allowDefaultCodec to false
         * prevents the netty component from installing a default codec as the
         * first element in the filter chain.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param allowDefaultCodec the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder allowDefaultCodec(boolean allowDefaultCodec) {
            doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
    
        
        /**
         * Whether or not to auto append missing end delimiter when sending
         * using the textline codec.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param autoAppendDelimiter the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder autoAppendDelimiter(boolean autoAppendDelimiter) {
            doSetProperty("autoAppendDelimiter", autoAppendDelimiter);
            return this;
        }
    
        
        /**
         * The max line length to use for the textline codec.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: codec
         * 
         * @param decoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder decoderMaxLineLength(int decoderMaxLineLength) {
            doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
    
        /**
         * A list of decoders to be used. You can use a String which have values
         * separated by comma, and have the values be looked up in the Registry.
         * Just remember to prefix the value with # so Camel knows it should
         * lookup.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param decoders the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder decoders(java.lang.String decoders) {
            doSetProperty("decoders", decoders);
            return this;
        }
    
        
        /**
         * The delimiter to use for the textline codec. Possible values are LINE
         * and NULL.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.TextLineDelimiter&lt;/code&gt; type.
         * 
         * Default: LINE
         * Group: codec
         * 
         * @param delimiter the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder delimiter(org.apache.camel.component.netty.TextLineDelimiter delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
    
        /**
         * A list of encoders to be used. You can use a String which have values
         * separated by comma, and have the values be looked up in the Registry.
         * Just remember to prefix the value with # so Camel knows it should
         * lookup.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param encoders the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder encoders(java.lang.String encoders) {
            doSetProperty("encoders", encoders);
            return this;
        }
    
        /**
         * The encoding (a charset name) to use for the textline codec. If not
         * provided, Camel will use the JVM default Charset.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param encoding the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder encoding(java.lang.String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
    
        
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP - however only
         * Strings are allowed to be serialized by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: codec
         * 
         * @param textline the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder textline(boolean textline) {
            doSetProperty("textline", textline);
            return this;
        }
    
        
        /**
         * Which protocols to enable when using SSL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: TLSv1.2,TLSv1.3
         * Group: security
         * 
         * @param enabledProtocols the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder enabledProtocols(java.lang.String enabledProtocols) {
            doSetProperty("enabledProtocols", enabledProtocols);
            return this;
        }
    
        
        /**
         * To enable/disable hostname verification on SSLEngine.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param hostnameVerification the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder hostnameVerification(boolean hostnameVerification) {
            doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }
    
        /**
         * Client side certificate keystore to be used for encryption.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFile the value to set
         * @return the dsl builder
         */
        @Deprecated
        default NettyHttpComponentBuilder keyStoreFile(java.io.File keyStoreFile) {
            doSetProperty("keyStoreFile", keyStoreFile);
            return this;
        }
    
        /**
         * Keystore format to be used for payload encryption. Defaults to JKS if
         * not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFormat the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder keyStoreFormat(java.lang.String keyStoreFormat) {
            doSetProperty("keyStoreFormat", keyStoreFormat);
            return this;
        }
    
        /**
         * Client side certificate keystore to be used for encryption. Is loaded
         * by default from classpath, but you can prefix with classpath:, file:,
         * or http: to load the resource from different systems.
         * 
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreResource the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder keyStoreResource(java.lang.String keyStoreResource) {
            doSetProperty("keyStoreResource", keyStoreResource);
            return this;
        }
    
        
        /**
         * Configures whether the server needs client authentication when using
         * SSL.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param needClientAuth the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder needClientAuth(boolean needClientAuth) {
            doSetProperty("needClientAuth", needClientAuth);
            return this;
        }
    
        /**
         * Password setting to use in order to encrypt/decrypt payloads sent
         * using SSH.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param passphrase the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder passphrase(java.lang.String passphrase) {
            doSetProperty("passphrase", passphrase);
            return this;
        }
    
        /**
         * Refers to a
         * org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration
         * for configuring secure web resources.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityConfiguration the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder securityConfiguration(org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration securityConfiguration) {
            doSetProperty("securityConfiguration", securityConfiguration);
            return this;
        }
    
        /**
         * Security provider to be used for payload encryption. Defaults to
         * SunX509 if not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityProvider the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder securityProvider(java.lang.String securityProvider) {
            doSetProperty("securityProvider", securityProvider);
            return this;
        }
    
        
        /**
         * Setting to specify whether SSL encryption is applied to this
         * endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder ssl(boolean ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
    
        
        /**
         * When enabled and in SSL mode, then the Netty consumer will enrich the
         * Camel Message with headers having information about the client
         * certificate such as subject name, issuer name, serial number, and the
         * valid date range.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param sslClientCertHeaders the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder sslClientCertHeaders(boolean sslClientCertHeaders) {
            doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }
    
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    
        /**
         * Reference to a class that could be used to return an SSL Handler.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.handler.ssl.SslHandler&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslHandler the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder sslHandler(io.netty.handler.ssl.SslHandler sslHandler) {
            doSetProperty("sslHandler", sslHandler);
            return this;
        }
    
        /**
         * Server side certificate keystore to be used for encryption.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreFile the value to set
         * @return the dsl builder
         */
        @Deprecated
        default NettyHttpComponentBuilder trustStoreFile(java.io.File trustStoreFile) {
            doSetProperty("trustStoreFile", trustStoreFile);
            return this;
        }
    
        /**
         * Server side certificate keystore to be used for encryption. Is loaded
         * by default from classpath, but you can prefix with classpath:, file:,
         * or http: to load the resource from different systems.
         * 
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreResource the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder trustStoreResource(java.lang.String trustStoreResource) {
            doSetProperty("trustStoreResource", trustStoreResource);
            return this;
        }
    
        
        /**
         * Enable usage of global SSL context parameters.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useGlobalSslContextParameters the value to set
         * @return the dsl builder
         */
        default NettyHttpComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }

    class NettyHttpComponentBuilderImpl
            extends AbstractComponentBuilder<NettyHttpComponent>
            implements NettyHttpComponentBuilder {
        @Override
        protected NettyHttpComponent buildConcreteComponent() {
            return new NettyHttpComponent();
        }
        private org.apache.camel.component.netty.NettyConfiguration getOrCreateConfiguration(NettyHttpComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.netty.NettyConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "configuration": ((NettyHttpComponent) component).setConfiguration((org.apache.camel.component.netty.NettyConfiguration) value); return true;
            case "disconnect": getOrCreateConfiguration((NettyHttpComponent) component).setDisconnect((boolean) value); return true;
            case "keepAlive": getOrCreateConfiguration((NettyHttpComponent) component).setKeepAlive((boolean) value); return true;
            case "reuseAddress": getOrCreateConfiguration((NettyHttpComponent) component).setReuseAddress((boolean) value); return true;
            case "reuseChannel": getOrCreateConfiguration((NettyHttpComponent) component).setReuseChannel((boolean) value); return true;
            case "sync": getOrCreateConfiguration((NettyHttpComponent) component).setSync((boolean) value); return true;
            case "tcpNoDelay": getOrCreateConfiguration((NettyHttpComponent) component).setTcpNoDelay((boolean) value); return true;
            case "bridgeErrorHandler": ((NettyHttpComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "clientMode": getOrCreateConfiguration((NettyHttpComponent) component).setClientMode((boolean) value); return true;
            case "muteException": ((NettyHttpComponent) component).setMuteException((boolean) value); return true;
            case "reconnect": getOrCreateConfiguration((NettyHttpComponent) component).setReconnect((boolean) value); return true;
            case "reconnectInterval": getOrCreateConfiguration((NettyHttpComponent) component).setReconnectInterval((int) value); return true;
            case "backlog": getOrCreateConfiguration((NettyHttpComponent) component).setBacklog((int) value); return true;
            case "bossCount": getOrCreateConfiguration((NettyHttpComponent) component).setBossCount((int) value); return true;
            case "bossGroup": getOrCreateConfiguration((NettyHttpComponent) component).setBossGroup((io.netty.channel.EventLoopGroup) value); return true;
            case "broadcast": getOrCreateConfiguration((NettyHttpComponent) component).setBroadcast((boolean) value); return true;
            case "disconnectOnNoReply": getOrCreateConfiguration((NettyHttpComponent) component).setDisconnectOnNoReply((boolean) value); return true;
            case "executorService": ((NettyHttpComponent) component).setExecutorService((io.netty.util.concurrent.EventExecutorGroup) value); return true;
            case "maximumPoolSize": ((NettyHttpComponent) component).setMaximumPoolSize((int) value); return true;
            case "nettyServerBootstrapFactory": getOrCreateConfiguration((NettyHttpComponent) component).setNettyServerBootstrapFactory((org.apache.camel.component.netty.NettyServerBootstrapFactory) value); return true;
            case "networkInterface": getOrCreateConfiguration((NettyHttpComponent) component).setNetworkInterface((java.lang.String) value); return true;
            case "noReplyLogLevel": getOrCreateConfiguration((NettyHttpComponent) component).setNoReplyLogLevel((org.apache.camel.LoggingLevel) value); return true;
            case "serverClosedChannelExceptionCaughtLogLevel": getOrCreateConfiguration((NettyHttpComponent) component).setServerClosedChannelExceptionCaughtLogLevel((org.apache.camel.LoggingLevel) value); return true;
            case "serverExceptionCaughtLogLevel": getOrCreateConfiguration((NettyHttpComponent) component).setServerExceptionCaughtLogLevel((org.apache.camel.LoggingLevel) value); return true;
            case "serverInitializerFactory": getOrCreateConfiguration((NettyHttpComponent) component).setServerInitializerFactory((org.apache.camel.component.netty.ServerInitializerFactory) value); return true;
            case "usingExecutorService": getOrCreateConfiguration((NettyHttpComponent) component).setUsingExecutorService((boolean) value); return true;
            case "connectTimeout": getOrCreateConfiguration((NettyHttpComponent) component).setConnectTimeout((int) value); return true;
            case "lazyStartProducer": ((NettyHttpComponent) component).setLazyStartProducer((boolean) value); return true;
            case "requestTimeout": getOrCreateConfiguration((NettyHttpComponent) component).setRequestTimeout((long) value); return true;
            case "clientInitializerFactory": getOrCreateConfiguration((NettyHttpComponent) component).setClientInitializerFactory((org.apache.camel.component.netty.ClientInitializerFactory) value); return true;
            case "correlationManager": getOrCreateConfiguration((NettyHttpComponent) component).setCorrelationManager((org.apache.camel.component.netty.NettyCamelStateCorrelationManager) value); return true;
            case "lazyChannelCreation": getOrCreateConfiguration((NettyHttpComponent) component).setLazyChannelCreation((boolean) value); return true;
            case "producerPoolBlockWhenExhausted": getOrCreateConfiguration((NettyHttpComponent) component).setProducerPoolBlockWhenExhausted((boolean) value); return true;
            case "producerPoolEnabled": getOrCreateConfiguration((NettyHttpComponent) component).setProducerPoolEnabled((boolean) value); return true;
            case "producerPoolMaxIdle": getOrCreateConfiguration((NettyHttpComponent) component).setProducerPoolMaxIdle((int) value); return true;
            case "producerPoolMaxTotal": getOrCreateConfiguration((NettyHttpComponent) component).setProducerPoolMaxTotal((int) value); return true;
            case "producerPoolMaxWait": getOrCreateConfiguration((NettyHttpComponent) component).setProducerPoolMaxWait((long) value); return true;
            case "producerPoolMinEvictableIdle": getOrCreateConfiguration((NettyHttpComponent) component).setProducerPoolMinEvictableIdle((long) value); return true;
            case "producerPoolMinIdle": getOrCreateConfiguration((NettyHttpComponent) component).setProducerPoolMinIdle((int) value); return true;
            case "udpConnectionlessSending": getOrCreateConfiguration((NettyHttpComponent) component).setUdpConnectionlessSending((boolean) value); return true;
            case "useByteBuf": getOrCreateConfiguration((NettyHttpComponent) component).setUseByteBuf((boolean) value); return true;
            case "allowSerializedHeaders": getOrCreateConfiguration((NettyHttpComponent) component).setAllowSerializedHeaders((boolean) value); return true;
            case "autowiredEnabled": ((NettyHttpComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "channelGroup": getOrCreateConfiguration((NettyHttpComponent) component).setChannelGroup((io.netty.channel.group.ChannelGroup) value); return true;
            case "headerFilterStrategy": ((NettyHttpComponent) component).setHeaderFilterStrategy((org.apache.camel.spi.HeaderFilterStrategy) value); return true;
            case "nativeTransport": getOrCreateConfiguration((NettyHttpComponent) component).setNativeTransport((boolean) value); return true;
            case "nettyHttpBinding": ((NettyHttpComponent) component).setNettyHttpBinding((org.apache.camel.component.netty.http.NettyHttpBinding) value); return true;
            case "options": getOrCreateConfiguration((NettyHttpComponent) component).setOptions((java.util.Map) value); return true;
            case "receiveBufferSize": getOrCreateConfiguration((NettyHttpComponent) component).setReceiveBufferSize((int) value); return true;
            case "receiveBufferSizePredictor": getOrCreateConfiguration((NettyHttpComponent) component).setReceiveBufferSizePredictor((int) value); return true;
            case "sendBufferSize": getOrCreateConfiguration((NettyHttpComponent) component).setSendBufferSize((int) value); return true;
            case "shutdownTimeout": getOrCreateConfiguration((NettyHttpComponent) component).setShutdownTimeout((int) value); return true;
            case "transferExchange": getOrCreateConfiguration((NettyHttpComponent) component).setTransferExchange((boolean) value); return true;
            case "udpByteArrayCodec": getOrCreateConfiguration((NettyHttpComponent) component).setUdpByteArrayCodec((boolean) value); return true;
            case "unixDomainSocketPath": getOrCreateConfiguration((NettyHttpComponent) component).setUnixDomainSocketPath((java.lang.String) value); return true;
            case "workerCount": getOrCreateConfiguration((NettyHttpComponent) component).setWorkerCount((int) value); return true;
            case "workerGroup": getOrCreateConfiguration((NettyHttpComponent) component).setWorkerGroup((io.netty.channel.EventLoopGroup) value); return true;
            case "allowDefaultCodec": getOrCreateConfiguration((NettyHttpComponent) component).setAllowDefaultCodec((boolean) value); return true;
            case "autoAppendDelimiter": getOrCreateConfiguration((NettyHttpComponent) component).setAutoAppendDelimiter((boolean) value); return true;
            case "decoderMaxLineLength": getOrCreateConfiguration((NettyHttpComponent) component).setDecoderMaxLineLength((int) value); return true;
            case "decoders": getOrCreateConfiguration((NettyHttpComponent) component).setDecoders((java.lang.String) value); return true;
            case "delimiter": getOrCreateConfiguration((NettyHttpComponent) component).setDelimiter((org.apache.camel.component.netty.TextLineDelimiter) value); return true;
            case "encoders": getOrCreateConfiguration((NettyHttpComponent) component).setEncoders((java.lang.String) value); return true;
            case "encoding": getOrCreateConfiguration((NettyHttpComponent) component).setEncoding((java.lang.String) value); return true;
            case "textline": getOrCreateConfiguration((NettyHttpComponent) component).setTextline((boolean) value); return true;
            case "enabledProtocols": getOrCreateConfiguration((NettyHttpComponent) component).setEnabledProtocols((java.lang.String) value); return true;
            case "hostnameVerification": getOrCreateConfiguration((NettyHttpComponent) component).setHostnameVerification((boolean) value); return true;
            case "keyStoreFile": getOrCreateConfiguration((NettyHttpComponent) component).setKeyStoreFile((java.io.File) value); return true;
            case "keyStoreFormat": getOrCreateConfiguration((NettyHttpComponent) component).setKeyStoreFormat((java.lang.String) value); return true;
            case "keyStoreResource": getOrCreateConfiguration((NettyHttpComponent) component).setKeyStoreResource((java.lang.String) value); return true;
            case "needClientAuth": getOrCreateConfiguration((NettyHttpComponent) component).setNeedClientAuth((boolean) value); return true;
            case "passphrase": getOrCreateConfiguration((NettyHttpComponent) component).setPassphrase((java.lang.String) value); return true;
            case "securityConfiguration": ((NettyHttpComponent) component).setSecurityConfiguration((org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration) value); return true;
            case "securityProvider": getOrCreateConfiguration((NettyHttpComponent) component).setSecurityProvider((java.lang.String) value); return true;
            case "ssl": getOrCreateConfiguration((NettyHttpComponent) component).setSsl((boolean) value); return true;
            case "sslClientCertHeaders": getOrCreateConfiguration((NettyHttpComponent) component).setSslClientCertHeaders((boolean) value); return true;
            case "sslContextParameters": getOrCreateConfiguration((NettyHttpComponent) component).setSslContextParameters((org.apache.camel.support.jsse.SSLContextParameters) value); return true;
            case "sslHandler": getOrCreateConfiguration((NettyHttpComponent) component).setSslHandler((io.netty.handler.ssl.SslHandler) value); return true;
            case "trustStoreFile": getOrCreateConfiguration((NettyHttpComponent) component).setTrustStoreFile((java.io.File) value); return true;
            case "trustStoreResource": getOrCreateConfiguration((NettyHttpComponent) component).setTrustStoreResource((java.lang.String) value); return true;
            case "useGlobalSslContextParameters": ((NettyHttpComponent) component).setUseGlobalSslContextParameters((boolean) value); return true;
            default: return false;
            }
        }
    }
}