/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.ibm.watson.language.WatsonLanguageComponent;

/**
 * Perform natural language processing using IBM Watson Natural Language
 * Understanding
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface IbmWatsonLanguageComponentBuilderFactory {

    /**
     * IBM Watson Language (camel-ibm-watson-language)
     * Perform natural language processing using IBM Watson Natural Language
     * Understanding
     * 
     * Category: ai,cloud
     * Since: 4.16
     * Maven coordinates: org.apache.camel:camel-ibm-watson-language
     * 
     * @return the dsl builder
     */
    static IbmWatsonLanguageComponentBuilder ibmWatsonLanguage() {
        return new IbmWatsonLanguageComponentBuilderImpl();
    }

    /**
     * Builder for the IBM Watson Language component.
     */
    interface IbmWatsonLanguageComponentBuilder extends ComponentBuilder<WatsonLanguageComponent> {
    
        /**
         * The service endpoint URL. If not specified, the default URL will be
         * used.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceUrl the value to set
         * @return the dsl builder
         */
        default IbmWatsonLanguageComponentBuilder serviceUrl(java.lang.String serviceUrl) {
            doSetProperty("serviceUrl", serviceUrl);
            return this;
        }
    
        
        /**
         * Enable category classification.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param analyzeCategories the value to set
         * @return the dsl builder
         */
        default IbmWatsonLanguageComponentBuilder analyzeCategories(boolean analyzeCategories) {
            doSetProperty("analyzeCategories", analyzeCategories);
            return this;
        }
    
        
        /**
         * Enable concept extraction.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param analyzeConcepts the value to set
         * @return the dsl builder
         */
        default IbmWatsonLanguageComponentBuilder analyzeConcepts(boolean analyzeConcepts) {
            doSetProperty("analyzeConcepts", analyzeConcepts);
            return this;
        }
    
        
        /**
         * Enable emotion analysis.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param analyzeEmotion the value to set
         * @return the dsl builder
         */
        default IbmWatsonLanguageComponentBuilder analyzeEmotion(boolean analyzeEmotion) {
            doSetProperty("analyzeEmotion", analyzeEmotion);
            return this;
        }
    
        
        /**
         * Enable entity extraction.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param analyzeEntities the value to set
         * @return the dsl builder
         */
        default IbmWatsonLanguageComponentBuilder analyzeEntities(boolean analyzeEntities) {
            doSetProperty("analyzeEntities", analyzeEntities);
            return this;
        }
    
        
        /**
         * Enable keyword extraction.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param analyzeKeywords the value to set
         * @return the dsl builder
         */
        default IbmWatsonLanguageComponentBuilder analyzeKeywords(boolean analyzeKeywords) {
            doSetProperty("analyzeKeywords", analyzeKeywords);
            return this;
        }
    
        
        /**
         * Enable sentiment analysis.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param analyzeSentiment the value to set
         * @return the dsl builder
         */
        default IbmWatsonLanguageComponentBuilder analyzeSentiment(boolean analyzeSentiment) {
            doSetProperty("analyzeSentiment", analyzeSentiment);
            return this;
        }
    
        /**
         * Component configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.ibm.watson.language.WatsonLanguageConfiguration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default IbmWatsonLanguageComponentBuilder configuration(org.apache.camel.component.ibm.watson.language.WatsonLanguageConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default IbmWatsonLanguageComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        /**
         * The operation to perform.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.ibm.watson.language.WatsonLanguageOperations&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default IbmWatsonLanguageComponentBuilder operation(org.apache.camel.component.ibm.watson.language.WatsonLanguageOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default IbmWatsonLanguageComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all consumer based health checks from
         * this component.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckConsumerEnabled the value to set
         * @return the dsl builder
         */
        default IbmWatsonLanguageComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all producer based health checks from
         * this component. Notice: Camel has by default disabled all producer
         * based health-checks. You can turn on producer checks globally by
         * setting camel.health.producersEnabled=true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckProducerEnabled the value to set
         * @return the dsl builder
         */
        default IbmWatsonLanguageComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }
    
        /**
         * The IBM Cloud API key for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default IbmWatsonLanguageComponentBuilder apiKey(java.lang.String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
    }

    class IbmWatsonLanguageComponentBuilderImpl
            extends AbstractComponentBuilder<WatsonLanguageComponent>
            implements IbmWatsonLanguageComponentBuilder {
        @Override
        protected WatsonLanguageComponent buildConcreteComponent() {
            return new WatsonLanguageComponent();
        }
        private org.apache.camel.component.ibm.watson.language.WatsonLanguageConfiguration getOrCreateConfiguration(WatsonLanguageComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.ibm.watson.language.WatsonLanguageConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "serviceUrl": getOrCreateConfiguration((WatsonLanguageComponent) component).setServiceUrl((java.lang.String) value); return true;
            case "analyzeCategories": getOrCreateConfiguration((WatsonLanguageComponent) component).setAnalyzeCategories((boolean) value); return true;
            case "analyzeConcepts": getOrCreateConfiguration((WatsonLanguageComponent) component).setAnalyzeConcepts((boolean) value); return true;
            case "analyzeEmotion": getOrCreateConfiguration((WatsonLanguageComponent) component).setAnalyzeEmotion((boolean) value); return true;
            case "analyzeEntities": getOrCreateConfiguration((WatsonLanguageComponent) component).setAnalyzeEntities((boolean) value); return true;
            case "analyzeKeywords": getOrCreateConfiguration((WatsonLanguageComponent) component).setAnalyzeKeywords((boolean) value); return true;
            case "analyzeSentiment": getOrCreateConfiguration((WatsonLanguageComponent) component).setAnalyzeSentiment((boolean) value); return true;
            case "configuration": ((WatsonLanguageComponent) component).setConfiguration((org.apache.camel.component.ibm.watson.language.WatsonLanguageConfiguration) value); return true;
            case "lazyStartProducer": ((WatsonLanguageComponent) component).setLazyStartProducer((boolean) value); return true;
            case "operation": getOrCreateConfiguration((WatsonLanguageComponent) component).setOperation((org.apache.camel.component.ibm.watson.language.WatsonLanguageOperations) value); return true;
            case "autowiredEnabled": ((WatsonLanguageComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "healthCheckConsumerEnabled": ((WatsonLanguageComponent) component).setHealthCheckConsumerEnabled((boolean) value); return true;
            case "healthCheckProducerEnabled": ((WatsonLanguageComponent) component).setHealthCheckProducerEnabled((boolean) value); return true;
            case "apiKey": getOrCreateConfiguration((WatsonLanguageComponent) component).setApiKey((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}