/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.IntegrationKitStatus;
import org.apache.camel.v1.integrationkitstatus.Artifacts;
import org.apache.camel.v1.integrationkitstatus.ArtifactsBuilder;
import org.apache.camel.v1.integrationkitstatus.ArtifactsFluent;
import org.apache.camel.v1.integrationkitstatus.Conditions;
import org.apache.camel.v1.integrationkitstatus.ConditionsBuilder;
import org.apache.camel.v1.integrationkitstatus.ConditionsFluent;
import org.apache.camel.v1.integrationkitstatus.Failure;
import org.apache.camel.v1.integrationkitstatus.FailureBuilder;
import org.apache.camel.v1.integrationkitstatus.FailureFluent;

public class IntegrationKitStatusFluent<A extends IntegrationKitStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ArtifactsBuilder> artifacts;
    private String baseImage;
    private ArrayList<ConditionsBuilder> conditions;
    private String digest;
    private FailureBuilder failure;
    private String image;
    private Long observedGeneration;
    private String phase;
    private String platform;
    private String rootImage;
    private String runtimeProvider;
    private String runtimeVersion;
    private String version;

    public IntegrationKitStatusFluent() {
    }

    public IntegrationKitStatusFluent(IntegrationKitStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IntegrationKitStatus instance) {
        IntegrationKitStatus integrationKitStatus = instance = instance != null ? instance : new IntegrationKitStatus();
        if (instance != null) {
            this.withArtifacts(instance.getArtifacts());
            this.withBaseImage(instance.getBaseImage());
            this.withConditions(instance.getConditions());
            this.withDigest(instance.getDigest());
            this.withFailure(instance.getFailure());
            this.withImage(instance.getImage());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPhase(instance.getPhase());
            this.withPlatform(instance.getPlatform());
            this.withRootImage(instance.getRootImage());
            this.withRuntimeProvider(instance.getRuntimeProvider());
            this.withRuntimeVersion(instance.getRuntimeVersion());
            this.withVersion(instance.getVersion());
        }
    }

    public A addToArtifacts(int index, Artifacts item) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        ArtifactsBuilder builder = new ArtifactsBuilder(item);
        if (index < 0 || index >= this.artifacts.size()) {
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        } else {
            this._visitables.get((Object)"artifacts").add(index, builder);
            this.artifacts.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToArtifacts(int index, Artifacts item) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        ArtifactsBuilder builder = new ArtifactsBuilder(item);
        if (index < 0 || index >= this.artifacts.size()) {
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        } else {
            this._visitables.get((Object)"artifacts").set(index, builder);
            this.artifacts.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToArtifacts(Artifacts ... items) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        for (Artifacts item : items) {
            ArtifactsBuilder builder = new ArtifactsBuilder(item);
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIntegrationkitstatusArtifacts(Collection<Artifacts> items) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        for (Artifacts item : items) {
            ArtifactsBuilder builder = new ArtifactsBuilder(item);
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromArtifacts(Artifacts ... items) {
        if (this.artifacts == null) {
            return (A)((Object)this);
        }
        for (Artifacts item : items) {
            ArtifactsBuilder builder = new ArtifactsBuilder(item);
            this._visitables.get((Object)"artifacts").remove((Object)builder);
            this.artifacts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIntegrationkitstatusArtifacts(Collection<Artifacts> items) {
        if (this.artifacts == null) {
            return (A)((Object)this);
        }
        for (Artifacts item : items) {
            ArtifactsBuilder builder = new ArtifactsBuilder(item);
            this._visitables.get((Object)"artifacts").remove((Object)builder);
            this.artifacts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIntegrationkitstatusArtifacts(Predicate<ArtifactsBuilder> predicate) {
        if (this.artifacts == null) {
            return (A)((Object)this);
        }
        Iterator<ArtifactsBuilder> each = this.artifacts.iterator();
        List visitables = this._visitables.get((Object)"artifacts");
        while (each.hasNext()) {
            ArtifactsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Artifacts> buildArtifacts() {
        return this.artifacts != null ? IntegrationKitStatusFluent.build(this.artifacts) : null;
    }

    public Artifacts buildArtifact(int index) {
        return this.artifacts.get(index).build();
    }

    public Artifacts buildFirstArtifact() {
        return this.artifacts.get(0).build();
    }

    public Artifacts buildLastArtifact() {
        return this.artifacts.get(this.artifacts.size() - 1).build();
    }

    public Artifacts buildMatchingArtifact(Predicate<ArtifactsBuilder> predicate) {
        for (ArtifactsBuilder item : this.artifacts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingArtifact(Predicate<ArtifactsBuilder> predicate) {
        for (ArtifactsBuilder item : this.artifacts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withArtifacts(List<Artifacts> artifacts) {
        if (this.artifacts != null) {
            this._visitables.get((Object)"artifacts").clear();
        }
        if (artifacts != null) {
            this.artifacts = new ArrayList();
            for (Artifacts item : artifacts) {
                this.addToArtifacts(item);
            }
        } else {
            this.artifacts = null;
        }
        return (A)((Object)this);
    }

    public A withArtifacts(Artifacts ... artifacts) {
        if (this.artifacts != null) {
            this.artifacts.clear();
            this._visitables.remove((Object)"artifacts");
        }
        if (artifacts != null) {
            for (Artifacts item : artifacts) {
                this.addToArtifacts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasArtifacts() {
        return this.artifacts != null && !this.artifacts.isEmpty();
    }

    public ArtifactsNested<A> addNewArtifact() {
        return new ArtifactsNested(-1, null);
    }

    public ArtifactsNested<A> addNewArtifactLike(Artifacts item) {
        return new ArtifactsNested(-1, item);
    }

    public ArtifactsNested<A> setNewArtifactLike(int index, Artifacts item) {
        return new ArtifactsNested(index, item);
    }

    public ArtifactsNested<A> editArtifact(int index) {
        if (this.artifacts.size() <= index) {
            throw new RuntimeException("Can't edit artifacts. Index exceeds size.");
        }
        return this.setNewArtifactLike(index, this.buildArtifact(index));
    }

    public ArtifactsNested<A> editFirstArtifact() {
        if (this.artifacts.size() == 0) {
            throw new RuntimeException("Can't edit first artifacts. The list is empty.");
        }
        return this.setNewArtifactLike(0, this.buildArtifact(0));
    }

    public ArtifactsNested<A> editLastArtifact() {
        int index = this.artifacts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last artifacts. The list is empty.");
        }
        return this.setNewArtifactLike(index, this.buildArtifact(index));
    }

    public ArtifactsNested<A> editMatchingArtifact(Predicate<ArtifactsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.artifacts.size(); ++i) {
            if (!predicate.test(this.artifacts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching artifacts. No match found.");
        }
        return this.setNewArtifactLike(index, this.buildArtifact(index));
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)((Object)this);
    }

    public boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public A addToConditions(int index, Conditions item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionsBuilder builder = new ConditionsBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Conditions item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionsBuilder builder = new ConditionsBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Conditions ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIntegrationkitstatusConditions(Collection<Conditions> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Conditions ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIntegrationkitstatusConditions(Collection<Conditions> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIntegrationkitstatusConditions(Predicate<ConditionsBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionsBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Conditions> buildConditions() {
        return this.conditions != null ? IntegrationKitStatusFluent.build(this.conditions) : null;
    }

    public Conditions buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Conditions buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Conditions buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Conditions buildMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        for (ConditionsBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        for (ConditionsBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Conditions> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Conditions item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Conditions ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Conditions item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Conditions item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Conditions item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getDigest() {
        return this.digest;
    }

    public A withDigest(String digest) {
        this.digest = digest;
        return (A)((Object)this);
    }

    public boolean hasDigest() {
        return this.digest != null;
    }

    public Failure buildFailure() {
        return this.failure != null ? this.failure.build() : null;
    }

    public A withFailure(Failure failure) {
        this._visitables.remove((Object)"failure");
        if (failure != null) {
            this.failure = new FailureBuilder(failure);
            this._visitables.get((Object)"failure").add(this.failure);
        } else {
            this.failure = null;
            this._visitables.get((Object)"failure").remove((Object)this.failure);
        }
        return (A)((Object)this);
    }

    public boolean hasFailure() {
        return this.failure != null;
    }

    public FailureNested<A> withNewFailure() {
        return new FailureNested(null);
    }

    public FailureNested<A> withNewFailureLike(Failure item) {
        return new FailureNested(item);
    }

    public FailureNested<A> editIntegrationkitstatusFailure() {
        return this.withNewFailureLike(Optional.ofNullable(this.buildFailure()).orElse(null));
    }

    public FailureNested<A> editOrNewFailure() {
        return this.withNewFailureLike(Optional.ofNullable(this.buildFailure()).orElse(new FailureBuilder().build()));
    }

    public FailureNested<A> editOrNewFailureLike(Failure item) {
        return this.withNewFailureLike(Optional.ofNullable(this.buildFailure()).orElse(item));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)((Object)this);
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public String getPlatform() {
        return this.platform;
    }

    public A withPlatform(String platform) {
        this.platform = platform;
        return (A)((Object)this);
    }

    public boolean hasPlatform() {
        return this.platform != null;
    }

    public String getRootImage() {
        return this.rootImage;
    }

    public A withRootImage(String rootImage) {
        this.rootImage = rootImage;
        return (A)((Object)this);
    }

    public boolean hasRootImage() {
        return this.rootImage != null;
    }

    public String getRuntimeProvider() {
        return this.runtimeProvider;
    }

    public A withRuntimeProvider(String runtimeProvider) {
        this.runtimeProvider = runtimeProvider;
        return (A)((Object)this);
    }

    public boolean hasRuntimeProvider() {
        return this.runtimeProvider != null;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public A withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return (A)((Object)this);
    }

    public boolean hasRuntimeVersion() {
        return this.runtimeVersion != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntegrationKitStatusFluent that = (IntegrationKitStatusFluent)((Object)o);
        if (!Objects.equals(this.artifacts, that.artifacts)) {
            return false;
        }
        if (!Objects.equals(this.baseImage, that.baseImage)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.digest, that.digest)) {
            return false;
        }
        if (!Objects.equals((Object)this.failure, (Object)that.failure)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.platform, that.platform)) {
            return false;
        }
        if (!Objects.equals(this.rootImage, that.rootImage)) {
            return false;
        }
        if (!Objects.equals(this.runtimeProvider, that.runtimeProvider)) {
            return false;
        }
        if (!Objects.equals(this.runtimeVersion, that.runtimeVersion)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.artifacts, this.baseImage, this.conditions, this.digest, this.failure, this.image, this.observedGeneration, this.phase, this.platform, this.rootImage, this.runtimeProvider, this.runtimeVersion, this.version, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.artifacts != null && !this.artifacts.isEmpty()) {
            sb.append("artifacts:");
            sb.append(this.artifacts + ",");
        }
        if (this.baseImage != null) {
            sb.append("baseImage:");
            sb.append(this.baseImage + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.digest != null) {
            sb.append("digest:");
            sb.append(this.digest + ",");
        }
        if (this.failure != null) {
            sb.append("failure:");
            sb.append(this.failure + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append(this.platform + ",");
        }
        if (this.rootImage != null) {
            sb.append("rootImage:");
            sb.append(this.rootImage + ",");
        }
        if (this.runtimeProvider != null) {
            sb.append("runtimeProvider:");
            sb.append(this.runtimeProvider + ",");
        }
        if (this.runtimeVersion != null) {
            sb.append("runtimeVersion:");
            sb.append(this.runtimeVersion + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ArtifactsNested<N>
    extends ArtifactsFluent<ArtifactsNested<N>>
    implements Nested<N> {
        ArtifactsBuilder builder;
        int index;

        ArtifactsNested(int index, Artifacts item) {
            this.index = index;
            this.builder = new ArtifactsBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationKitStatusFluent.this.setToArtifacts(this.index, this.builder.build());
        }

        public N endIntegrationkitstatusArtifact() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ConditionsFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionsBuilder builder;
        int index;

        ConditionsNested(int index, Conditions item) {
            this.index = index;
            this.builder = new ConditionsBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationKitStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endIntegrationkitstatusCondition() {
            return this.and();
        }
    }

    public class FailureNested<N>
    extends FailureFluent<FailureNested<N>>
    implements Nested<N> {
        FailureBuilder builder;

        FailureNested(Failure item) {
            this.builder = new FailureBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationKitStatusFluent.this.withFailure(this.builder.build());
        }

        public N endIntegrationkitstatusFailure() {
            return this.and();
        }
    }
}

