/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.buildspec.tasks;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.buildspec.tasks.Jib;
import org.apache.camel.v1.buildspec.tasks.jib.Configuration;
import org.apache.camel.v1.buildspec.tasks.jib.ConfigurationBuilder;
import org.apache.camel.v1.buildspec.tasks.jib.ConfigurationFluent;
import org.apache.camel.v1.buildspec.tasks.jib.Registry;
import org.apache.camel.v1.buildspec.tasks.jib.RegistryBuilder;
import org.apache.camel.v1.buildspec.tasks.jib.RegistryFluent;

public class JibFluent<A extends JibFluent<A>>
extends BaseFluent<A> {
    private String baseImage;
    private ConfigurationBuilder configuration;
    private String contextDir;
    private String image;
    private String name;
    private RegistryBuilder registry;

    public JibFluent() {
    }

    public JibFluent(Jib instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Jib instance) {
        Jib jib = instance = instance != null ? instance : new Jib();
        if (instance != null) {
            this.withBaseImage(instance.getBaseImage());
            this.withConfiguration(instance.getConfiguration());
            this.withContextDir(instance.getContextDir());
            this.withImage(instance.getImage());
            this.withName(instance.getName());
            this.withRegistry(instance.getRegistry());
        }
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)((Object)this);
    }

    public boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public String getContextDir() {
        return this.contextDir;
    }

    public A withContextDir(String contextDir) {
        this.contextDir = contextDir;
        return (A)((Object)this);
    }

    public boolean hasContextDir() {
        return this.contextDir != null;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Registry buildRegistry() {
        return this.registry != null ? this.registry.build() : null;
    }

    public A withRegistry(Registry registry) {
        this._visitables.remove((Object)"registry");
        if (registry != null) {
            this.registry = new RegistryBuilder(registry);
            this._visitables.get((Object)"registry").add(this.registry);
        } else {
            this.registry = null;
            this._visitables.get((Object)"registry").remove((Object)this.registry);
        }
        return (A)((Object)this);
    }

    public boolean hasRegistry() {
        return this.registry != null;
    }

    public RegistryNested<A> withNewRegistry() {
        return new RegistryNested(null);
    }

    public RegistryNested<A> withNewRegistryLike(Registry item) {
        return new RegistryNested(item);
    }

    public RegistryNested<A> editJibRegistry() {
        return this.withNewRegistryLike(Optional.ofNullable(this.buildRegistry()).orElse(null));
    }

    public RegistryNested<A> editOrNewRegistry() {
        return this.withNewRegistryLike(Optional.ofNullable(this.buildRegistry()).orElse(new RegistryBuilder().build()));
    }

    public RegistryNested<A> editOrNewRegistryLike(Registry item) {
        return this.withNewRegistryLike(Optional.ofNullable(this.buildRegistry()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JibFluent that = (JibFluent)((Object)o);
        if (!Objects.equals(this.baseImage, that.baseImage)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.contextDir, that.contextDir)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals((Object)this.registry, (Object)that.registry);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseImage, this.configuration, this.contextDir, this.image, this.name, this.registry, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baseImage != null) {
            sb.append("baseImage:");
            sb.append(this.baseImage + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.contextDir != null) {
            sb.append("contextDir:");
            sb.append(this.contextDir + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.registry != null) {
            sb.append("registry:");
            sb.append((Object)this.registry);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)JibFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }

    public class RegistryNested<N>
    extends RegistryFluent<RegistryNested<N>>
    implements Nested<N> {
        RegistryBuilder builder;

        RegistryNested(Registry item) {
            this.builder = new RegistryBuilder(this, item);
        }

        public N and() {
            return (N)JibFluent.this.withRegistry(this.builder.build());
        }

        public N endJibRegistry() {
            return this.and();
        }
    }
}

