/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.template.spec.volumes;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.FlexVolume;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.flexvolume.SecretRef;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.flexvolume.SecretRefBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.flexvolume.SecretRefFluent;

public class FlexVolumeFluent<A extends FlexVolumeFluent<A>>
extends BaseFluent<A> {
    private String driver;
    private String fsType;
    private Map<String, String> options;
    private Boolean readOnly;
    private SecretRefBuilder secretRef;

    public FlexVolumeFluent() {
    }

    public FlexVolumeFluent(FlexVolume instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(FlexVolume instance) {
        FlexVolume flexVolume = instance = instance != null ? instance : new FlexVolume();
        if (instance != null) {
            this.withDriver(instance.getDriver());
            this.withFsType(instance.getFsType());
            this.withOptions(instance.getOptions());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretRef(instance.getSecretRef());
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public A withDriver(String driver) {
        this.driver = driver;
        return (A)((Object)this);
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)((Object)this);
    }

    public boolean hasFsType() {
        return this.fsType != null;
    }

    public A addToOptions(String key, String value) {
        if (this.options == null && key != null && value != null) {
            this.options = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.options.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToOptions(Map<String, String> map) {
        if (this.options == null && map != null) {
            this.options = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.options.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromOptions(String key) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        if (key != null && this.options != null) {
            this.options.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromOptions(Map<String, String> map) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.options == null) continue;
                this.options.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public <K, V> A withOptions(Map<String, String> options) {
        this.options = options == null ? null : new LinkedHashMap<String, String>(options);
        return (A)((Object)this);
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)((Object)this);
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public SecretRef buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(SecretRef secretRef) {
        this._visitables.remove((Object)"secretRef");
        if (secretRef != null) {
            this.secretRef = new SecretRefBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove((Object)this.secretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(SecretRef item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editFlexvolumeSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new SecretRefBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(SecretRef item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FlexVolumeFluent that = (FlexVolumeFluent)((Object)o);
        if (!Objects.equals(this.driver, that.driver)) {
            return false;
        }
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        return Objects.equals((Object)this.secretRef, (Object)that.secretRef);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.driver, this.fsType, this.options, this.readOnly, this.secretRef, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver + ",");
        }
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(this.options + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append((Object)this.secretRef);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public class SecretRefNested<N>
    extends SecretRefFluent<SecretRefNested<N>>
    implements Nested<N> {
        SecretRefBuilder builder;

        SecretRefNested(SecretRef item) {
            this.builder = new SecretRefBuilder(this, item);
        }

        public N and() {
            return (N)FlexVolumeFluent.this.withSecretRef(this.builder.build());
        }

        public N endFlexvolumeSecretRef() {
            return this.and();
        }
    }
}

