/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.Property;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyVisitor;

public abstract class BaseProperty
implements Property {
    protected ClassDescriptor owner;
    protected Accessor accessor;
    final String name;

    public BaseProperty(ClassDescriptor owner, Accessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException("Null accessor");
        }
        this.accessor = accessor;
        this.owner = owner;
        this.name = accessor.getName();
    }

    public Object readProperty(Object object) throws PropertyException {
        return this.readPropertyDirectly(object);
    }

    public void writeProperty(Object object, Object oldValue, Object newValue) throws PropertyException {
        this.writePropertyDirectly(object, oldValue, newValue);
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean visit(PropertyVisitor var1);

    public void injectValueHolder(Object object) throws PropertyException {
    }

    public Object readPropertyDirectly(Object object) throws PropertyException {
        return this.accessor.getValue(object);
    }

    public void writePropertyDirectly(Object object, Object oldValue, Object newValue) throws PropertyException {
        this.accessor.setValue(object, newValue);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getName()).append('@').append(System.identityHashCode(this)).append('[').append(this.name).append(']');
        return buffer.toString();
    }
}

