/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;

public abstract class QueryAssembler {
    protected Query query;
    protected QueryMetadata queryMetadata;
    protected boolean translated;
    protected String sql;
    protected DbAdapter adapter;
    protected EntityResolver entityResolver;
    protected List<DbAttributeBinding> bindings;
    protected AddBindingListener addBindingListener;

    public QueryAssembler(Query query, DbAdapter adapter, EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
        this.adapter = adapter;
        this.query = query;
        this.queryMetadata = query.getMetaData(entityResolver);
        this.bindings = new ArrayList<DbAttributeBinding>();
    }

    protected Map<String, String> getPathAliases() {
        return this.queryMetadata.getPathSplitAliases();
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public Query getQuery() {
        return this.query;
    }

    public QueryMetadata getQueryMetadata() {
        return this.queryMetadata;
    }

    public abstract void resetJoinStack();

    public abstract String getCurrentAlias();

    public abstract void dbRelationshipAdded(DbRelationship var1, JoinType var2, String var3);

    public String getSql() {
        this.ensureTranslated();
        return this.sql;
    }

    protected void ensureTranslated() {
        if (!this.translated) {
            this.doTranslate();
            this.translated = true;
        }
    }

    protected abstract void doTranslate();

    public boolean supportsTableAliases() {
        return false;
    }

    public void addToParamList(DbAttribute dbAttr, Object anObject) {
        ExtendedType extendedType = anObject != null ? this.adapter.getExtendedTypes().getRegisteredType(anObject.getClass()) : this.adapter.getExtendedTypes().getDefaultType();
        DbAttributeBinding binding = new DbAttributeBinding(dbAttr);
        binding.setStatementPosition(this.bindings.size() + 1);
        binding.setValue(anObject);
        binding.setExtendedType(extendedType);
        this.bindings.add(binding);
        if (this.addBindingListener != null) {
            this.addBindingListener.onAdd(binding);
        }
    }

    public DbAttributeBinding[] getBindings() {
        return this.bindings.toArray(new DbAttributeBinding[this.bindings.size()]);
    }

    public abstract String getAliasForExpression(Expression var1);

    public void setAddBindingListener(AddBindingListener addBindingListener) {
        this.addBindingListener = addBindingListener;
    }

    protected static interface AddBindingListener {
        public void onAdd(DbAttributeBinding var1);
    }
}

