/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.MapBuilder;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.JavaGroupsBridgeProvider;

public class JGroupsModule
implements Module {
    public static final String JAVA_GROUPS_BRIDGE_PROPERTIES_MAP = "cayenne.server.java_group_bridge";

    public static void contributeMulticastAddress(Binder binder, String address) {
        JGroupsModule.contributeProperties(binder).put("cayenne.JavaGroupsBridge.mcast.address", (Object)address);
    }

    public static void contributeMulticastPort(Binder binder, int port) {
        JGroupsModule.contributeProperties(binder).put("cayenne.JavaGroupsBridge.mcast.port", (Object)Integer.toString(port));
    }

    public static void contributeConfigUrl(Binder binder, String config) {
        JGroupsModule.contributeProperties(binder).put("javagroupsbridge.config.url", (Object)config);
    }

    private static MapBuilder<String> contributeProperties(Binder binder) {
        return binder.bindMap(String.class, JAVA_GROUPS_BRIDGE_PROPERTIES_MAP);
    }

    public void configure(Binder binder) {
        JGroupsModule.contributeMulticastAddress(binder, "228.0.0.5");
        JGroupsModule.contributeMulticastPort(binder, 22222);
        binder.bind(EventBridge.class).toProvider(JavaGroupsBridgeProvider.class).withoutScope();
    }
}

