/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache.invalidation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.cayenne.DataChannelSyncFilter;
import org.apache.cayenne.DataChannelSyncFilterChain;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.annotation.PrePersist;
import org.apache.cayenne.annotation.PreRemove;
import org.apache.cayenne.annotation.PreUpdate;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.invalidation.CacheGroupDescriptor;
import org.apache.cayenne.cache.invalidation.InvalidationHandler;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.graph.GraphDiff;

public class CacheInvalidationFilter
implements DataChannelSyncFilter {
    private final Provider<QueryCache> cacheProvider;
    private final List<InvalidationHandler> handlers;
    private final Map<Class<? extends Persistent>, Function<Persistent, Collection<CacheGroupDescriptor>>> mappedHandlers = new ConcurrentHashMap<Class<? extends Persistent>, Function<Persistent, Collection<CacheGroupDescriptor>>>();
    private final Function<Persistent, Collection<CacheGroupDescriptor>> skipHandler = p -> Collections.emptyList();
    private final ThreadLocal<Set<CacheGroupDescriptor>> groups = new ThreadLocal();

    public CacheInvalidationFilter(@Inject Provider<QueryCache> cacheProvider, @Inject List<InvalidationHandler> handlers) {
        this.cacheProvider = cacheProvider;
        this.handlers = handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType, DataChannelSyncFilterChain filterChain) {
        try {
            GraphDiff result = filterChain.onSync(originatingContext, changes, syncType);
            Collection groupSet = this.groups.get();
            if (groupSet != null && !groupSet.isEmpty()) {
                QueryCache cache = (QueryCache)this.cacheProvider.get();
                for (CacheGroupDescriptor group : groupSet) {
                    if (group.getKeyType() != Void.class) {
                        cache.removeGroup(group.getCacheGroupName(), group.getKeyType(), group.getValueType());
                        continue;
                    }
                    cache.removeGroup(group.getCacheGroupName());
                }
            }
            GraphDiff graphDiff = result;
            return graphDiff;
        }
        finally {
            this.groups.set(null);
        }
    }

    @PrePersist
    @PreRemove
    @PreUpdate
    protected void preCommit(Object object) {
        Persistent p = (Persistent)object;
        Function invalidationFunction = this.mappedHandlers.computeIfAbsent(p.getClass(), cl -> {
            for (InvalidationHandler handler : this.handlers) {
                Function<Persistent, Collection<CacheGroupDescriptor>> function = handler.canHandle((Class<? extends Persistent>)cl);
                if (function == null) continue;
                return function;
            }
            return this.skipHandler;
        });
        Collection objectGroups = (Collection)invalidationFunction.apply(p);
        if (!objectGroups.isEmpty()) {
            this.getOrCreateTxGroups().addAll(objectGroups);
        }
    }

    protected Set<CacheGroupDescriptor> getOrCreateTxGroups() {
        Set<CacheGroupDescriptor> txGroups = this.groups.get();
        if (txGroups == null) {
            txGroups = new HashSet<CacheGroupDescriptor>();
            this.groups.set(txGroups);
        }
        return txGroups;
    }
}

