/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.apache.cayenne.crypto.transformer.value.BytesConverter;
import org.apache.cayenne.crypto.transformer.value.LongConverter;

public class DurationConverter
implements BytesConverter<Duration> {
    public static final BytesConverter<Duration> INSTANCE = new DurationConverter(LongConverter.INSTANCE);
    private BytesConverter<Long> longConverter;

    DurationConverter(BytesConverter<Long> longConverter) {
        this.longConverter = Objects.requireNonNull(longConverter);
    }

    @Override
    public Duration fromBytes(byte[] bytes) {
        return Duration.of(this.longConverter.fromBytes(bytes), ChronoUnit.MILLIS);
    }

    @Override
    public byte[] toBytes(Duration value) {
        return this.longConverter.toBytes(value.toMillis());
    }
}

