/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataDomainQueryAction;

class ResultIteratorConverterDecorator<T, R>
implements ResultIterator<R> {
    private final ResultIterator<T> iterator;
    private final DataDomainQueryAction.ObjectConversionStrategy<T, R> converter;

    ResultIteratorConverterDecorator(ResultIterator<T> iterator, DataDomainQueryAction.ObjectConversionStrategy<T, R> converter) {
        this.iterator = Objects.requireNonNull(iterator);
        this.converter = Objects.requireNonNull(converter);
    }

    @Override
    public List<R> allRows() {
        List<T> mainRows = this.iterator.allRows();
        this.converter.convert(mainRows);
        return mainRows;
    }

    @Override
    public boolean hasNextRow() {
        return this.iterator.hasNextRow();
    }

    @Override
    public R nextRow() {
        return this.converter.convert(this.iterator.nextRow());
    }

    @Override
    public void skipRow() {
        this.iterator.skipRow();
    }

    @Override
    public void close() {
        this.iterator.close();
    }

    @Override
    public Iterator<R> iterator() {
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return ResultIteratorConverterDecorator.this.iterator.hasNextRow();
            }

            @Override
            public R next() {
                return ResultIteratorConverterDecorator.this.converter.convert(ResultIteratorConverterDecorator.this.iterator.nextRow());
            }
        };
    }
}

