/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.cayenne.datasource.PoolingDataSource;
import org.apache.cayenne.datasource.PoolingDataSourceManager;
import org.apache.cayenne.datasource.StoppedDataSource;
import org.apache.cayenne.datasource.UnmanagedPoolingDataSource;
import org.apache.cayenne.di.ScopeEventListener;

public class ManagedPoolingDataSource
implements PoolingDataSource,
ScopeEventListener {
    private final PoolingDataSourceManager dataSourceManager;
    private DataSource dataSource;

    public ManagedPoolingDataSource(UnmanagedPoolingDataSource dataSource) {
        this(dataSource, 120000L);
    }

    public ManagedPoolingDataSource(UnmanagedPoolingDataSource dataSource, long managerWakeTime) {
        this.dataSource = dataSource;
        this.dataSourceManager = new PoolingDataSourceManager(dataSource, managerWakeTime);
        this.dataSourceManager.start();
    }

    PoolingDataSourceManager getDataSourceManager() {
        return this.dataSourceManager;
    }

    int poolSize() {
        return this.dataSourceManager.getDataSource().poolSize();
    }

    int availableSize() {
        return this.dataSourceManager.getDataSource().availableSize();
    }

    int canExpandSize() {
        return this.dataSourceManager.getDataSource().canExpandSize();
    }

    @Override
    public void beforeScopeEnd() {
        this.close();
    }

    @Override
    public void close() {
        this.dataSource = new StoppedDataSource(this.dataSource);
        this.dataSourceManager.shutdown();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.dataSource.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return ManagedPoolingDataSource.class.equals(iface) || this.dataSource.isWrapperFor(iface);
    }

    @Override
    public void setLogWriter(PrintWriter arg0) throws SQLException {
        this.dataSource.setLogWriter(arg0);
    }

    @Override
    public void setLoginTimeout(int arg0) throws SQLException {
        this.dataSource.setLoginTimeout(arg0);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)(ManagedPoolingDataSource.class.equals(iface) ? this : this.dataSource.unwrap(iface));
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }
}

