/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlite;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.cayenne.access.types.CalendarType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.sqlite.SQLiteDateType;

class SQLiteCalendarType<T extends Calendar>
implements ExtendedType<Calendar> {
    protected ExtendedType<Calendar> delegateCalendarType;
    protected ExtendedType<Date> delegateDateType;

    public SQLiteCalendarType(Class<T> calendarClass) {
        this.delegateCalendarType = new CalendarType<T>(calendarClass);
        this.delegateDateType = new SQLiteDateType();
    }

    @Override
    public String getClassName() {
        return this.delegateCalendarType.getClassName();
    }

    @Override
    public Calendar materializeObject(CallableStatement rs, int index, int type) throws Exception {
        Date date = this.delegateDateType.materializeObject(rs, index, type);
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    @Override
    public Calendar materializeObject(ResultSet rs, int index, int type) throws Exception {
        Date date = this.delegateDateType.materializeObject(rs, index, type);
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Calendar value, int pos, int type, int precision) throws Exception {
        this.delegateCalendarType.setJdbcObject(statement, value, pos, type, precision);
    }

    @Override
    public String toString(Calendar value) {
        if (value == null) {
            return "NULL";
        }
        return value.getClass().getName() + "(" + new Timestamp(value.getTimeInMillis()) + ")";
    }
}

