/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.util.Collection;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.RelationshipProperty;

public abstract class CollectionProperty<V extends Persistent, E extends Collection<V>>
extends BaseProperty<E>
implements RelationshipProperty<E> {
    protected Class<V> entityType;

    protected CollectionProperty(CayennePath path, Expression expression, Class<? super E> collectionType, Class<V> entityType) {
        super(path, expression, collectionType);
        this.entityType = entityType;
    }

    public EntityProperty<V> flat() {
        return PropertyFactory.createEntity(ExpressionFactory.fullObjectExp(this.getExpression()), this.getEntityType());
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression contains(V value) {
        return this.containsValue(value);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression notContains(V value) {
        return this.notContainsValue(value);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression contains(V firstValue, V ... moreValues) {
        int moreValuesLength = moreValues != null ? moreValues.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstValue;
        if (moreValuesLength > 0) {
            System.arraycopy(moreValues, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.inExp(this.getExpression(), values);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression contains(Collection<V> values) {
        return ExpressionFactory.inExp(this.getExpression(), values);
    }

    public Expression containsId(Object id) {
        return ExpressionFactory.matchExp(this.getExpression(), id);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression containsId(Object firstId, Object ... moreId) {
        int moreValuesLength = moreId != null ? moreId.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstId;
        if (moreValuesLength > 0) {
            System.arraycopy(moreId, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.inExp(this.getExpression(), values);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression containsId(Collection<Object> ids) {
        return ExpressionFactory.inExp(this.getExpression(), ids);
    }

    public Expression notContainsId(Object id) {
        return ExpressionFactory.noMatchExp(this.getExpression(), id);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression notContainsId(Object firstId, Object ... moreId) {
        int moreValuesLength = moreId != null ? moreId.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstId;
        if (moreValuesLength > 0) {
            System.arraycopy(moreId, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.notInExp(this.getExpression(), values);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression notContainsId(Collection<Object> ids) {
        return ExpressionFactory.notInExp(this.getExpression(), ids);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression notContains(Collection<V> values) {
        return ExpressionFactory.notInExp(this.getExpression(), values);
    }

    @Deprecated(since="5.0", forRemoval=true)
    @SafeVarargs
    public final Expression notContains(V firstValue, V ... moreValues) {
        int moreValuesLength = moreValues != null ? moreValues.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstValue;
        if (moreValuesLength > 0) {
            System.arraycopy(moreValues, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.notInExp(this.getExpression(), values);
    }

    public Expression containsValue(V value) {
        return ExpressionFactory.matchExp(this.getExpression(), value);
    }

    public Expression notContainsValue(V value) {
        return ExpressionFactory.noMatchExp(this.getExpression(), value);
    }

    @SafeVarargs
    public final Expression containsValues(V ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("At least one value is expected.");
        }
        return ExpressionFactory.inExp(this.getExpression(), (Object[])values);
    }

    public Expression containsValuesCollection(Collection<V> values) {
        return ExpressionFactory.inExp(this.getExpression(), values);
    }

    public Expression containsIds(Object ... ids) {
        return ExpressionFactory.inExp(this.getExpression(), ids);
    }

    public Expression containsIdsCollection(Collection<?> ids) {
        return ExpressionFactory.inExp(this.getExpression(), ids);
    }

    public Expression notContainsIds(Object ... ids) {
        return ExpressionFactory.notInExp(this.getExpression(), ids);
    }

    public Expression notContainsIdsCollection(Collection<?> ids) {
        return ExpressionFactory.notInExp(this.getExpression(), ids);
    }

    public Expression notContainsValuesCollection(Collection<V> values) {
        return ExpressionFactory.notInExp(this.getExpression(), values);
    }

    @SafeVarargs
    public final Expression notContainsValues(V ... values) {
        return ExpressionFactory.notInExp(this.getExpression(), (Object[])values);
    }

    protected Class<V> getEntityType() {
        return this.entityType;
    }
}

