/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class CheckBoxHeader
extends JCheckBox
implements TableCellRenderer,
MouseListener {
    protected int column;
    protected boolean mousePressed = false;
    private final CheckBoxHeader rendererComponent = this;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        this.column = column;
        if (table != null && (header = table.getTableHeader()) != null) {
            header.addMouseListener(this.rendererComponent);
        }
        this.rendererComponent.setBackground(UIManager.getColor("Table.selectionBackground"));
        this.setBorder(UIManager.getBorder("CheckBoxHeader.border"));
        return this.rendererComponent;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mousePressed) {
            this.mousePressed = false;
            JTableHeader header = (JTableHeader)e.getSource();
            int columnAtPoint = header.columnAtPoint(e.getPoint());
            if (columnAtPoint == this.column) {
                this.doClick();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

