/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.extension.info;

import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.configuration.xml.DataMapHandler;
import org.apache.cayenne.configuration.xml.DbEntityHandler;
import org.apache.cayenne.configuration.xml.DbRelationshipHandler;
import org.apache.cayenne.configuration.xml.EmbeddableHandler;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.configuration.xml.ObjEntityHandler;
import org.apache.cayenne.configuration.xml.ObjRelationshipHandler;
import org.apache.cayenne.configuration.xml.ProcedureHandler;
import org.apache.cayenne.configuration.xml.QueryDescriptorHandler;
import org.apache.cayenne.project.extension.info.ObjectInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class PropertyHandler
extends NamespaceAwareNestedTagHandler {
    static final String PROPERTY_TAG = "property";
    private static final Logger logger = LoggerFactory.getLogger(PropertyHandler.class);
    private DataChannelMetaData metaData;

    PropertyHandler(NamespaceAwareNestedTagHandler parentHandler, DataChannelMetaData metaData) {
        super(parentHandler);
        this.setTargetNamespace("http://cayenne.apache.org/schema/11/info");
        this.metaData = metaData;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "property": {
                ConfigurationNode parentObject = this.getParentObject();
                String name = attributes.getValue("name");
                if (parentObject != null) {
                    String oldValue;
                    ObjectInfo info = this.metaData.get(parentObject, ObjectInfo.class);
                    if (info == null) {
                        info = new ObjectInfo();
                        this.metaData.add(parentObject, info);
                    }
                    if ((oldValue = info.put(name, attributes.getValue("value"))) != null) {
                        logger.warn("Duplicated property {} for object {}", (Object)name, (Object)parentObject);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String qName, Attributes attributes) {
        return super.createChildTagHandler(namespaceURI, localName, qName, attributes);
    }

    private ConfigurationNode getParentObject() {
        if (this.parentHandler instanceof DataMapHandler) {
            return ((DataMapHandler)this.parentHandler).getDataMap();
        }
        if (this.parentHandler instanceof DbEntityHandler) {
            return ((DbEntityHandler)this.parentHandler).getEntity();
        }
        if (this.parentHandler instanceof ObjEntityHandler) {
            return ((ObjEntityHandler)this.parentHandler).getEntity();
        }
        if (this.parentHandler instanceof EmbeddableHandler) {
            return ((EmbeddableHandler)this.parentHandler).getEmbeddable();
        }
        if (this.parentHandler instanceof QueryDescriptorHandler) {
            return ((QueryDescriptorHandler)this.parentHandler).getQueryDescriptor();
        }
        if (this.parentHandler instanceof ProcedureHandler) {
            return ((ProcedureHandler)this.parentHandler).getProcedure();
        }
        if (this.parentHandler instanceof DbRelationshipHandler) {
            return ((DbRelationshipHandler)this.parentHandler).getDbRelationship();
        }
        if (this.parentHandler instanceof ObjRelationshipHandler) {
            return ((ObjRelationshipHandler)this.parentHandler).getObjRelationship();
        }
        if (this.parentHandler instanceof NamespaceAwareNestedTagHandler) {
            ContentHandler parentParentHandler = ((NamespaceAwareNestedTagHandler)this.parentHandler).getParentHandler();
            if (parentParentHandler instanceof DbEntityHandler) {
                return ((DbEntityHandler)parentParentHandler).getLastAttribute();
            }
            if (parentParentHandler instanceof ObjEntityHandler) {
                return ((ObjEntityHandler)parentParentHandler).getLastAttribute();
            }
        }
        return null;
    }
}

