/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataChannelDescriptorLoader;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;
import org.apache.cayenne.project.upgrade.UpgradeMetaData;
import org.apache.cayenne.project.upgrade.UpgradeService;
import org.apache.cayenne.project.upgrade.UpgradeType;
import org.apache.cayenne.project.upgrade.UpgradeUnit;
import org.apache.cayenne.project.upgrade.handlers.UpgradeHandler;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultUpgradeService
implements UpgradeService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultUpgradeService.class);
    public static final String UNKNOWN_VERSION = "0";
    public static final String MIN_SUPPORTED_VERSION = "6";
    TreeMap<String, UpgradeHandler> handlers = new TreeMap(VersionComparator.INSTANCE);
    @Inject
    private ProjectSaver projectSaver;
    @Inject
    private DataChannelDescriptorLoader loader;

    public DefaultUpgradeService(@Inject List<UpgradeHandler> handlerList) {
        for (UpgradeHandler handler : handlerList) {
            this.handlers.put(handler.getVersion(), handler);
        }
    }

    @Override
    public UpgradeMetaData getUpgradeType(Resource resource) {
        UpgradeMetaData metaData = new UpgradeMetaData();
        String version = this.loadProjectVersion(resource);
        metaData.setProjectVersion(version);
        metaData.setSupportedVersion(String.valueOf(11));
        int c1 = VersionComparator.INSTANCE.compare(version, MIN_SUPPORTED_VERSION);
        if (c1 < 0) {
            metaData.setIntermediateUpgradeVersion(MIN_SUPPORTED_VERSION);
            metaData.setUpgradeType(UpgradeType.INTERMEDIATE_UPGRADE_NEEDED);
            return metaData;
        }
        int c2 = VersionComparator.INSTANCE.compare(String.valueOf(11), version);
        if (c2 < 0) {
            metaData.setUpgradeType(UpgradeType.DOWNGRADE_NEEDED);
        } else if (c2 == 0) {
            metaData.setUpgradeType(UpgradeType.UPGRADE_NOT_NEEDED);
        } else {
            metaData.setUpgradeType(UpgradeType.UPGRADE_NEEDED);
        }
        return metaData;
    }

    protected List<UpgradeHandler> getHandlersForVersion(String version) {
        boolean found = MIN_SUPPORTED_VERSION.equals(version);
        ArrayList<UpgradeHandler> handlerList = new ArrayList<UpgradeHandler>();
        for (Map.Entry<String, UpgradeHandler> entry : this.handlers.entrySet()) {
            if (entry.getKey().equals(version)) {
                found = true;
                continue;
            }
            if (!found) continue;
            handlerList.add(entry.getValue());
        }
        return handlerList;
    }

    @Override
    public Resource upgradeProject(Resource resource) {
        List<UpgradeHandler> handlerList = this.getHandlersForVersion(this.loadProjectVersion(resource));
        List<UpgradeUnit> upgradeUnits = this.upgradeDOM(resource, handlerList);
        this.saveDOM(upgradeUnits);
        resource = upgradeUnits.get(0).getResource();
        ConfigurationTree<DataChannelDescriptor> configurationTree = this.upgradeModel(resource, handlerList);
        this.saveModel(configurationTree);
        return resource;
    }

    protected List<UpgradeUnit> upgradeDOM(Resource resource, List<UpgradeHandler> handlerList) {
        ArrayList<UpgradeUnit> allUnits = new ArrayList<UpgradeUnit>();
        Document projectDocument = Util.readDocument(resource.getURL());
        UpgradeUnit projectUnit = new UpgradeUnit(resource, projectDocument);
        allUnits.add(projectUnit);
        List<Resource> dataMapResources = this.getAdditionalDatamapResources(projectUnit);
        ArrayList<UpgradeUnit> dataMapUnits = new ArrayList<UpgradeUnit>(dataMapResources.size());
        for (Resource dataMapResource : dataMapResources) {
            dataMapUnits.add(new UpgradeUnit(dataMapResource, Util.readDocument(dataMapResource.getURL())));
        }
        allUnits.addAll(dataMapUnits);
        for (UpgradeHandler handler : handlerList) {
            handler.processProjectDom(projectUnit);
            for (UpgradeUnit dataMapUnit : dataMapUnits) {
                handler.processDataMapDom(dataMapUnit);
            }
        }
        return allUnits;
    }

    protected void saveDOM(Collection<UpgradeUnit> upgradeUnits) {
        for (UpgradeUnit unit : upgradeUnits) {
            this.saveDocument(unit);
        }
    }

    protected ConfigurationTree<DataChannelDescriptor> upgradeModel(Resource resource, List<UpgradeHandler> handlerList) {
        ConfigurationTree<DataChannelDescriptor> configurationTree = this.loadProject(resource);
        for (UpgradeHandler handler : handlerList) {
            handler.processModel(configurationTree.getRootNode());
        }
        return configurationTree;
    }

    protected ConfigurationTree<DataChannelDescriptor> loadProject(Resource resource) {
        ConfigurationTree<DataChannelDescriptor> configurationTree = this.loader.load(resource);
        EntityResolver resolver = new EntityResolver();
        for (DataMap dataMap : configurationTree.getRootNode().getDataMaps()) {
            resolver.addDataMap(dataMap);
            dataMap.setNamespace(resolver);
        }
        return configurationTree;
    }

    protected void saveModel(ConfigurationTree<DataChannelDescriptor> configurationTree) {
        Project project = new Project(configurationTree);
        this.projectSaver.save(project);
    }

    List<Resource> getAdditionalDatamapResources(UpgradeUnit upgradeUnit) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate("/domain/map/@name", upgradeUnit.getDocument(), XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node mapNode = nodes.item(i);
                Resource mapResource = upgradeUnit.getResource().getRelativeResource(mapNode.getNodeValue() + ".map.xml");
                resources.add(mapResource);
            }
        }
        catch (Exception ex) {
            logger.warn("Can't get additional dataMap resources: ", ex);
        }
        return resources;
    }

    protected void saveDocument(UpgradeUnit upgradeUnit) {
        try {
            DOMSource input = new DOMSource(upgradeUnit.getDocument());
            StreamResult output = new StreamResult(Util.toFile(upgradeUnit.getResource().getURL()));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(input, output);
        }
        catch (Exception ex) {
            logger.warn("Can't save the document: ", ex);
        }
    }

    protected String loadProjectVersion(Resource resource) {
        RootTagHandler rootHandler = new RootTagHandler();
        URL url = resource.getURL();
        try (InputStream in2 = url.openStream();){
            XMLReader parser = Util.createXmlReader();
            parser.setContentHandler(rootHandler);
            parser.setErrorHandler(rootHandler);
            parser.parse(new InputSource(in2));
        }
        catch (SAXException in2) {
        }
        catch (Exception e) {
            throw new ConfigurationException("Error reading configuration from %s", (Throwable)e, url);
        }
        return rootHandler.projectVersion != null ? rootHandler.projectVersion : UNKNOWN_VERSION;
    }

    protected static double decodeVersion(String version) {
        if (version == null || Util.isBlank(version)) {
            return 0.0;
        }
        StringBuilder buffer = new StringBuilder(version.length());
        boolean dotProcessed = false;
        for (int i = 0; i < version.length(); ++i) {
            char nextChar = version.charAt(i);
            if (nextChar == '.' && !dotProcessed) {
                dotProcessed = true;
                buffer.append('.');
                continue;
            }
            if (!Character.isDigit(nextChar)) continue;
            buffer.append(nextChar);
        }
        return Double.parseDouble(buffer.toString());
    }

    private static class VersionComparator
    implements Comparator<String> {
        private static final VersionComparator INSTANCE = new VersionComparator();

        private VersionComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            double v2Double;
            if (o1.equals(o2)) {
                return 0;
            }
            double v1Double = DefaultUpgradeService.decodeVersion(o1);
            return v1Double < (v2Double = DefaultUpgradeService.decodeVersion(o2)) ? -1 : 1;
        }
    }

    class RootTagHandler
    extends DefaultHandler {
        private String projectVersion;

        RootTagHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.projectVersion = attributes.getValue("", "project-version");
            throw new SAXException("finished");
        }
    }
}

