/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.apache.cayenne.project.validation.BaseQueryValidator;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.validation.ValidationResult;

class SelectQueryValidator
extends BaseQueryValidator<SelectQueryDescriptor> {
    public SelectQueryValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(SelectQueryDescriptor node, ValidationResult validationResult) {
        ConfigurationNodeValidator.Performer<SelectQueryDescriptor> performer = this.validateQuery(node, validationResult);
        performer.performIfEnabled(Inspection.SELECT_QUERY_NO_ROOT, this::checkForRoot);
        Entity<?, ?, ?> root = this.getRootForValidation(node);
        if (root == null) {
            return;
        }
        performer.performIfEnabled(Inspection.SELECT_QUERY_INVALID_QUALIFIER, () -> this.validateQualifier(root, node.getQualifier(), validationResult));
        for (Ordering ordering : node.getOrderings()) {
            performer.performIfEnabled(Inspection.SELECT_QUERY_INVALID_ORDERING_PATH, () -> this.validateOrdering(node, root, ordering, validationResult));
        }
        if (node.getPrefetchesMap() == null) {
            return;
        }
        for (String prefetchPath : node.getPrefetchesMap().keySet()) {
            performer.performIfEnabled(Inspection.SELECT_QUERY_INVALID_PREFETCH_PATH, () -> this.validatePrefetch(root, prefetchPath, validationResult));
        }
    }

    private void validatePrefetch(Entity<?, ?, ?> root, String path, ValidationResult validationResult) {
    }

    private void validateOrdering(SelectQueryDescriptor query, Entity<?, ?, ?> root, Ordering ordering, ValidationResult validationResult) {
        String path = ordering.getSortSpecString();
        Iterator<CayenneMapEntry> it = root.resolvePathComponents(path);
        while (it.hasNext()) {
            try {
                it.next();
            }
            catch (ExpressionException e) {
                this.addFailure(validationResult, query, "Invalid ordering path: '%s'", path);
            }
        }
    }

    private void validateQualifier(Entity<?, ?, ?> root, Expression qualifier, ValidationResult validationResult) {
    }

    private void checkForRoot(SelectQueryDescriptor query, ValidationResult validationResult) {
        DataMap map = query.getDataMap();
        if (query.getRoot() == null && map != null) {
            this.addFailure(validationResult, query, "Query '%s' has no root", query.getName());
        }
    }

    private Entity<?, ?, ?> getRootForValidation(SelectQueryDescriptor query) {
        DataMap parent;
        DataMap map = query.getDataMap();
        if (query.getRoot() == null && map != null) {
            return null;
        }
        if (query.getRoot() == map) {
            return null;
        }
        if (map == null) {
            return query.getRoot() instanceof Entity ? (Entity)query.getRoot() : null;
        }
        if (query.getRoot() instanceof Entity) {
            return (Entity)query.getRoot();
        }
        if (query.getRoot() instanceof Class) {
            return null;
        }
        if (query.getRoot() instanceof String && (parent = query.getDataMap()) != null) {
            return parent.getNamespace().getObjEntity((String)query.getRoot());
        }
        return null;
    }
}

