/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.dbsync.filter.NameFilter;
import org.apache.cayenne.dbsync.filter.NamePatternMatcher;
import org.apache.cayenne.dbsync.reverse.configuration.ToolsModule;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.gen.ArtifactsGenerationMode;
import org.apache.cayenne.gen.CgenConfigList;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.CgenTemplate;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClassGenerationActionFactory;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.tools.AntLogger;
import org.apache.cayenne.tools.CayenneGeneratorEmbeddableFilterAction;
import org.apache.cayenne.tools.CayenneGeneratorEntityFilterAction;
import org.apache.cayenne.tools.CayenneGeneratorMapLoaderAction;
import org.apache.cayenne.tools.CayenneTask;
import org.apache.cayenne.tools.ToolsInjectorBuilder;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CayenneGeneratorTask
extends CayenneTask {
    private AntLogger logger;
    protected String includeEntitiesPattern;
    protected String excludeEntitiesPattern;
    protected String excludeEmbeddablesPattern;
    protected File map;
    protected File[] additionalMaps;
    protected File destDir;
    protected String encoding;
    protected Boolean makepairs;
    protected String mode;
    protected String outputPattern;
    protected Boolean overwrite;
    protected String superpkg;
    protected String supertemplate;
    protected String template;
    protected String embeddabletemplate;
    protected String embeddablesupertemplate;
    protected String datamaptemplate;
    protected String datamapsupertemplate;
    protected Boolean usepkgpath;
    protected Boolean createpropertynames;
    private boolean force;
    private boolean useConfigFromDataMap;
    private transient Injector injector;
    protected Boolean createpkproperties;
    protected String externaltoolconfig;

    public void execute() throws BuildException {
        this.validateAttributes();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this.injector = new ToolsInjectorBuilder().addModule((Module)new ToolsModule(LoggerFactory.getLogger(CayenneGeneratorTask.class))).create();
        this.logger = new AntLogger(this);
        CayenneGeneratorMapLoaderAction loadAction = new CayenneGeneratorMapLoaderAction(this.injector);
        loadAction.setMainDataMapFile(this.map);
        loadAction.setAdditionalDataMapFiles(this.additionalMaps);
        try {
            Thread.currentThread().setContextClassLoader(CayenneGeneratorTask.class.getClassLoader());
            DataMap dataMap = loadAction.getMainDataMap();
            for (ClassGenerationAction generatorAction : this.createGenerators(dataMap)) {
                CayenneGeneratorEntityFilterAction filterEntityAction = new CayenneGeneratorEntityFilterAction();
                filterEntityAction.setNameFilter((NameFilter)NamePatternMatcher.build((Logger)this.logger, (String)this.includeEntitiesPattern, (String)this.excludeEntitiesPattern));
                CayenneGeneratorEmbeddableFilterAction filterEmbeddableAction = new CayenneGeneratorEmbeddableFilterAction();
                filterEmbeddableAction.setNameFilter((NameFilter)NamePatternMatcher.build((Logger)this.logger, null, (String)this.excludeEmbeddablesPattern));
                generatorAction.setLogger((Logger)this.logger);
                if (this.force) {
                    generatorAction.getCgenConfiguration().setForce(true);
                }
                generatorAction.getCgenConfiguration().setTimestamp(this.map.lastModified());
                if (!this.hasConfig() && this.useConfigFromDataMap) {
                    generatorAction.prepareArtifacts();
                } else {
                    generatorAction.addEntities(filterEntityAction.getFilteredEntities(dataMap));
                    generatorAction.addEmbeddables(filterEmbeddableAction.getFilteredEmbeddables(dataMap));
                    generatorAction.addDataMap(dataMap);
                }
                generatorAction.execute();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    private List<ClassGenerationAction> createGenerators(DataMap dataMap) {
        ArrayList<ClassGenerationAction> actions = new ArrayList<ClassGenerationAction>();
        for (CgenConfiguration configuration : this.buildConfigurations(dataMap)) {
            actions.add(((ClassGenerationActionFactory)this.injector.getInstance(ClassGenerationActionFactory.class)).createAction(configuration));
        }
        return actions;
    }

    private boolean hasConfig() {
        return this.destDir != null || this.encoding != null || this.excludeEntitiesPattern != null || this.excludeEmbeddablesPattern != null || this.includeEntitiesPattern != null || this.makepairs != null || this.mode != null || this.outputPattern != null || this.overwrite != null || this.superpkg != null || this.supertemplate != null || this.template != null || this.embeddabletemplate != null || this.embeddablesupertemplate != null || this.usepkgpath != null || this.createpropertynames != null || this.datamaptemplate != null || this.datamapsupertemplate != null || this.createpkproperties != null || this.force || this.externaltoolconfig != null;
    }

    List<CgenConfiguration> buildConfigurations(DataMap dataMap) {
        CgenConfigList cgenConfigList = (CgenConfigList)((DataChannelMetaData)this.injector.getInstance(DataChannelMetaData.class)).get((ConfigurationNode)dataMap, CgenConfigList.class);
        if (this.hasConfig()) {
            this.logger.info("Using cgen config from pom.xml");
            return Collections.singletonList(this.cgenConfigFromPom(dataMap));
        }
        if (cgenConfigList != null) {
            this.logger.info("Using cgen config from dataMap");
            this.useConfigFromDataMap = true;
            return cgenConfigList.getAll();
        }
        this.logger.info("Using default cgen config.");
        CgenConfiguration cgenConfiguration = new CgenConfiguration();
        cgenConfiguration.setDataMap(dataMap);
        return Collections.singletonList(cgenConfiguration);
    }

    private CgenConfiguration cgenConfigFromPom(DataMap dataMap) {
        CgenConfiguration cgenConfiguration = new CgenConfiguration();
        cgenConfiguration.setDataMap(dataMap);
        if (this.destDir != null) {
            cgenConfiguration.updateOutputPath(this.destDir.toPath());
        }
        cgenConfiguration.setEncoding(this.encoding != null ? this.encoding : cgenConfiguration.getEncoding());
        cgenConfiguration.setMakePairs(this.makepairs != null ? this.makepairs.booleanValue() : cgenConfiguration.isMakePairs());
        if (this.mode != null && this.mode.equals("datamap")) {
            this.replaceDatamapGenerationMode();
        }
        cgenConfiguration.setArtifactsGenerationMode(this.mode != null ? this.mode : cgenConfiguration.getArtifactsGenerationMode());
        cgenConfiguration.setOutputPattern(this.outputPattern != null ? this.outputPattern : cgenConfiguration.getOutputPattern());
        cgenConfiguration.setOverwrite(this.overwrite != null ? this.overwrite.booleanValue() : cgenConfiguration.isOverwrite());
        cgenConfiguration.setSuperPkg(this.superpkg != null ? this.superpkg : cgenConfiguration.getSuperPkg());
        cgenConfiguration.setSuperTemplate(this.supertemplate != null ? new CgenTemplate(this.supertemplate, true, TemplateType.ENTITY_SUPERCLASS) : cgenConfiguration.getSuperTemplate());
        cgenConfiguration.setTemplate(this.template != null ? new CgenTemplate(this.template, true, TemplateType.ENTITY_SUBCLASS) : cgenConfiguration.getTemplate());
        cgenConfiguration.setEmbeddableSuperTemplate(this.embeddablesupertemplate != null ? new CgenTemplate(this.embeddablesupertemplate, true, TemplateType.EMBEDDABLE_SUPERCLASS) : cgenConfiguration.getEmbeddableSuperTemplate());
        cgenConfiguration.setEmbeddableTemplate(this.embeddabletemplate != null ? new CgenTemplate(this.embeddabletemplate, true, TemplateType.EMBEDDABLE_SUBCLASS) : cgenConfiguration.getEmbeddableTemplate());
        cgenConfiguration.setUsePkgPath(this.usepkgpath != null ? this.usepkgpath.booleanValue() : cgenConfiguration.isUsePkgPath());
        cgenConfiguration.setCreatePropertyNames(this.createpropertynames != null ? this.createpropertynames.booleanValue() : cgenConfiguration.isCreatePropertyNames());
        cgenConfiguration.setDataMapTemplate(this.datamaptemplate != null ? new CgenTemplate(this.datamaptemplate, true, TemplateType.DATAMAP_SUBCLASS) : cgenConfiguration.getDataMapTemplate());
        cgenConfiguration.setDataMapSuperTemplate(this.datamapsupertemplate != null ? new CgenTemplate(this.datamapsupertemplate, true, TemplateType.DATAMAP_SUPERCLASS) : cgenConfiguration.getDataMapSuperTemplate());
        cgenConfiguration.setCreatePKProperties(this.createpkproperties != null ? this.createpkproperties.booleanValue() : cgenConfiguration.isCreatePKProperties());
        cgenConfiguration.setExternalToolConfig(this.externaltoolconfig != null ? this.externaltoolconfig : cgenConfiguration.getExternalToolConfig());
        if (!cgenConfiguration.isMakePairs()) {
            if (this.template == null) {
                cgenConfiguration.setTemplate(TemplateType.ENTITY_SINGLE_CLASS.defaultTemplate());
            }
            if (this.embeddabletemplate == null) {
                cgenConfiguration.setEmbeddableTemplate(TemplateType.EMBEDDABLE_SINGLE_CLASS.defaultTemplate());
            }
            if (this.datamaptemplate == null) {
                cgenConfiguration.setDataMapTemplate(TemplateType.DATAMAP_SINGLE_CLASS.defaultTemplate());
            }
        }
        return cgenConfiguration;
    }

    private void replaceDatamapGenerationMode() {
        this.mode = ArtifactsGenerationMode.ALL.getLabel();
        this.excludeEntitiesPattern = "*";
        this.excludeEmbeddablesPattern = "*";
        this.includeEntitiesPattern = "";
    }

    protected void validateAttributes() throws BuildException {
        if (this.map == null && this.getProject() == null) {
            throw new BuildException("either 'map' or 'project' is required.");
        }
    }

    @Override
    public void setMap(File map) {
        this.map = map;
    }

    public void setAdditionalMaps(Path additionalMapsPath) {
        String[] additionalMapFilenames = additionalMapsPath.list();
        this.additionalMaps = new File[additionalMapFilenames.length];
        for (int i = 0; i < additionalMapFilenames.length; ++i) {
            this.additionalMaps[i] = new File(additionalMapFilenames[i]);
        }
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setMakepairs(boolean makepairs) {
        this.makepairs = makepairs;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setSupertemplate(String supertemplate) {
        this.supertemplate = supertemplate;
    }

    public void setDataMapTemplate(String datamaptemplate) {
        this.datamaptemplate = datamaptemplate;
    }

    public void setDataMapSupertemplate(String datamapsupertemplate) {
        this.datamapsupertemplate = datamapsupertemplate;
    }

    public void setUsepkgpath(boolean usepkgpath) {
        this.usepkgpath = usepkgpath;
    }

    public void setSuperpkg(String superpkg) {
        this.superpkg = superpkg;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setExcludeEntities(String excludeEntitiesPattern) {
        this.excludeEntitiesPattern = excludeEntitiesPattern;
    }

    public void setIncludeEntities(String includeEntitiesPattern) {
        this.includeEntitiesPattern = includeEntitiesPattern;
    }

    public void setExcludeEmbeddablesPattern(String excludeEmbeddablesPattern) {
        this.excludeEmbeddablesPattern = excludeEmbeddablesPattern;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setCreatepropertynames(boolean createpropertynames) {
        this.createpropertynames = createpropertynames;
    }

    public void setEmbeddabletemplate(String embeddabletemplate) {
        this.embeddabletemplate = embeddabletemplate;
    }

    public void setEmbeddablesupertemplate(String embeddablesupertemplate) {
        this.embeddablesupertemplate = embeddablesupertemplate;
    }

    public void setCreatepkproperties(boolean createpkproperties) {
        this.createpkproperties = createpkproperties;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setExternaltoolconfig(String externaltoolconfig) {
        this.externaltoolconfig = externaltoolconfig;
    }
}

