/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import javax.sql.DataSource;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.DataSourceDescriptor;
import org.apache.cayenne.configuration.runtime.DataSourceFactory;
import org.apache.cayenne.configuration.runtime.DbAdapterFactory;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.DbSyncModule;
import org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator;
import org.apache.cayenne.dbsync.reverse.configuration.ToolsModule;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportAction;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportConfiguration;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportConfigurationValidator;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportModule;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeRelationship;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfigBuilder;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.tools.AntLogger;
import org.apache.cayenne.tools.AntTableType;
import org.apache.cayenne.util.Util;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.slf4j.Logger;

public class DbImporterTask
extends Task {
    private final DbImportConfiguration config = new DbImportConfiguration();
    private ReverseEngineering reverseEngineering;

    public DbImporterTask() {
        this.config.setUseJava7Types(false);
        this.config.setNamingStrategy(DefaultObjectNameGenerator.class.getName());
        this.reverseEngineering = new ReverseEngineering();
    }

    public void addIncludeColumn(IncludeColumn includeColumn) {
        this.reverseEngineering.addIncludeColumn(includeColumn);
    }

    public void addExcludeColumn(ExcludeColumn excludeColumn) {
        this.reverseEngineering.addExcludeColumn(excludeColumn);
    }

    public void addIncludeTable(IncludeTable includeTable) {
        this.reverseEngineering.addIncludeTable(includeTable);
    }

    public void addExcludeTable(ExcludeTable excludeTable) {
        this.reverseEngineering.addExcludeTable(excludeTable);
    }

    public void addExcludeRelationship(ExcludeRelationship excludeRelationship) {
        this.reverseEngineering.addExcludeRelationship(excludeRelationship);
    }

    public void addIncludeProcedure(IncludeProcedure includeProcedure) {
        this.reverseEngineering.addIncludeProcedure(includeProcedure);
    }

    public void addExcludeProcedure(ExcludeProcedure excludeProcedure) {
        this.reverseEngineering.addExcludeProcedure(excludeProcedure);
    }

    public void setSkipRelationshipsLoading(boolean skipRelationshipsLoading) {
        this.reverseEngineering.setSkipRelationshipsLoading(Boolean.valueOf(skipRelationshipsLoading));
    }

    public void setSkipPrimaryKeyLoading(boolean skipPrimaryKeyLoading) {
        this.reverseEngineering.setSkipPrimaryKeyLoading(Boolean.valueOf(skipPrimaryKeyLoading));
    }

    public void addConfiguredTableType(AntTableType type) {
        this.reverseEngineering.addTableType(type.getName());
    }

    public void addConfiguredSchema(Schema schema) {
        this.reverseEngineering.addSchema(schema);
    }

    public void addCatalog(Catalog catalog) {
        this.reverseEngineering.addCatalog(catalog);
    }

    public void execute() {
        AntLogger logger = new AntLogger(this);
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{new DbSyncModule(), new ToolsModule((Logger)logger), new DbImportModule()});
        if (this.reverseEngineering.getCatalogs().size() == 0 && this.reverseEngineering.isEmptyContainer()) {
            this.config.setUseDataMapReverseEngineering(true);
        }
        DataSourceFactory dataSourceFactory = (DataSourceFactory)injector.getInstance(DataSourceFactory.class);
        DbAdapterFactory dbAdapterFactory = (DbAdapterFactory)injector.getInstance(DbAdapterFactory.class);
        DataNodeDescriptor dataNodeDescriptor = this.config.createDataNodeDescriptor();
        try {
            DataSource dataSource = dataSourceFactory.getDataSource(dataNodeDescriptor);
            DbAdapter dbAdapter = dbAdapterFactory.createAdapter(dataNodeDescriptor, dataSource);
            this.config.setFiltersConfig(new FiltersConfigBuilder(this.reverseEngineering).dataSource(dataSource).dbAdapter(dbAdapter).build());
        }
        catch (Exception e) {
            throw new BuildException("Error getting dataSource", (Throwable)e);
        }
        this.validateAttributes();
        this.config.setLogger((Logger)logger);
        this.config.setSkipRelationshipsLoading(this.reverseEngineering.getSkipRelationshipsLoading());
        this.config.setSkipPrimaryKeyLoading(this.reverseEngineering.getSkipPrimaryKeyLoading());
        this.config.setTableTypes(this.reverseEngineering.getTableTypes());
        DbImportConfigurationValidator validator = new DbImportConfigurationValidator(this.reverseEngineering, this.config, injector);
        try {
            validator.validate();
        }
        catch (Exception ex) {
            throw new BuildException(ex.getMessage(), (Throwable)ex);
        }
        try {
            ((DbImportAction)injector.getInstance(DbImportAction.class)).execute(this.config);
        }
        catch (Exception ex) {
            Throwable th = Util.unwindException((Throwable)ex);
            Object message = "Error importing database schema";
            if (th.getLocalizedMessage() != null) {
                message = (String)message + ": " + th.getLocalizedMessage();
            }
            this.log((String)message, 0);
            throw new BuildException((String)message, th);
        }
        finally {
            injector.shutdown();
        }
    }

    protected void validateAttributes() throws BuildException {
        DataSourceDescriptor dataSourceInfo;
        StringBuilder error = new StringBuilder("");
        if (this.config.getTargetDataMap() == null) {
            error.append("The 'map' attribute must be set.\n");
        }
        if ((dataSourceInfo = this.config.getDataSourceInfo()).getJdbcDriver() == null) {
            error.append("The 'driver' attribute must be set.\n");
        }
        if (dataSourceInfo.getDataSourceUrl() == null) {
            error.append("The 'url' attribute must be set.\n");
        }
        if (error.length() > 0) {
            throw new BuildException(error.toString());
        }
    }

    public void setDefaultPackage(String defaultPackage) {
        this.config.setDefaultPackage(defaultPackage);
    }

    public void setMeaningfulPkTables(String meaningfulPkTables) {
        this.config.setMeaningfulPkTables(meaningfulPkTables);
    }

    public void setNamingStrategy(String namingStrategy) {
        this.config.setNamingStrategy(namingStrategy);
    }

    public void setStripFromTableNames(String pattern) {
        this.config.setStripFromTableNames(pattern);
    }

    public void setAdapter(String adapter) {
        this.config.setAdapter(adapter);
    }

    public void setDriver(String driver) {
        this.config.setDriver(driver);
    }

    public void setPassword(String password) {
        this.config.setPassword(password);
    }

    public void setUrl(String url) {
        this.config.setUrl(url);
    }

    public void setUserName(String username) {
        this.config.setUsername(username);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public void setUsePrimitives(boolean flag) {
    }

    public void setUseJava7Types(boolean flag) {
        this.config.setUseJava7Types(flag);
    }

    public void setForceDataMapCatalog(boolean flag) {
        this.config.setForceDataMapCatalog(flag);
    }

    public void setForceDataMapSchema(boolean flag) {
        this.config.setForceDataMapSchema(flag);
    }

    public ReverseEngineering getReverseEngineering() {
        return this.reverseEngineering;
    }

    public File getMap() {
        return this.config.getTargetDataMap();
    }

    public void setMap(File map) {
        this.config.setTargetDataMap(map);
    }

    public File getCayenneProject() {
        return this.config.getCayenneProject();
    }

    public void setCayenneProject(File cayenneProject) {
        this.config.setCayenneProject(cayenneProject);
    }

    public DbImportConfiguration toParameters() {
        return this.config;
    }
}

