/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.dbsync.merge.MergerDictionary;
import org.apache.cayenne.dbsync.merge.MergerDiffPair;

class MergerDictionaryDiff<T> {
    private List<MergerDiffPair<T>> same = new LinkedList<MergerDiffPair<T>>();
    private List<MergerDiffPair<T>> missing = new LinkedList<MergerDiffPair<T>>();

    MergerDictionaryDiff() {
    }

    public List<MergerDiffPair<T>> getSame() {
        return this.same;
    }

    public List<MergerDiffPair<T>> getMissing() {
        return this.missing;
    }

    public void addAll(MergerDictionaryDiff<T> other) {
        this.same.addAll(other.getSame());
        this.missing.addAll(other.getMissing());
    }

    static class Builder<T> {
        private MergerDictionaryDiff<T> diff;
        private MergerDictionary<T> originalDictionary;
        private MergerDictionary<T> importedDictionary;
        private Set<String> sameNames = new HashSet<String>();

        Builder() {
            this.diff = new MergerDictionaryDiff();
        }

        Builder<T> originalDictionary(MergerDictionary<T> dictionary) {
            this.originalDictionary = dictionary;
            return this;
        }

        Builder<T> importedDictionary(MergerDictionary<T> dictionary) {
            this.importedDictionary = dictionary;
            return this;
        }

        MergerDictionaryDiff<T> build() {
            if (this.originalDictionary == null || this.importedDictionary == null) {
                throw new IllegalArgumentException("Dictionaries not set");
            }
            this.originalDictionary.init();
            this.importedDictionary.init();
            this.diff.same = this.buildSame();
            this.diff.missing = this.buildMissing();
            return this.diff;
        }

        private List<MergerDiffPair<T>> buildSame() {
            LinkedList<MergerDiffPair<T>> sameEntities = new LinkedList<MergerDiffPair<T>>();
            for (Map.Entry<String, T> entry : this.originalDictionary.getDictionary().entrySet()) {
                String name = entry.getKey();
                T original = entry.getValue();
                T imported = this.importedDictionary.getByName(name);
                if (imported == null) continue;
                MergerDiffPair<T> pair = new MergerDiffPair<T>(original, imported);
                sameEntities.add(pair);
                this.sameNames.add(name);
            }
            return sameEntities;
        }

        private List<MergerDiffPair<T>> buildMissing() {
            LinkedList<MergerDiffPair<T>> missingEntities = new LinkedList<MergerDiffPair<T>>();
            this.addMissingFromDictionary(missingEntities, this.originalDictionary, true);
            this.addMissingFromDictionary(missingEntities, this.importedDictionary, false);
            return missingEntities;
        }

        private void addMissingFromDictionary(List<MergerDiffPair<T>> missingEntities, MergerDictionary<T> dictionary, boolean isOriginal) {
            for (Map.Entry<String, T> entry : dictionary.getDictionary().entrySet()) {
                if (this.sameNames.contains(entry.getKey())) continue;
                MergerDiffPair<Object> pair = new MergerDiffPair<Object>((isOriginal ? (Object)entry.getValue() : null), (isOriginal ? null : (Object)entry.getValue()));
                missingEntities.add(pair);
            }
        }
    }
}

