/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.translator.select.OrderingAbstractStage;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.query.Ordering;

class OrderingDistinctStage
extends OrderingAbstractStage {
    OrderingDistinctStage() {
    }

    @Override
    public void perform(TranslatorContext context) {
        if (context.getQuery().getOrderings() == null) {
            return;
        }
        if (this.isDistinct(context)) {
            QualifierTranslator qualifierTranslator = context.getQualifierTranslator();
            for (Ordering ordering : context.getQuery().getOrderings()) {
                this.processOrdering(qualifierTranslator, context, ordering);
            }
        }
    }

    private boolean isDistinct(TranslatorContext context) {
        return !context.isDistinctSuppression() && (context.getQuery().isDistinct() || context.getTableTree().hasToManyJoin());
    }
}

