/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.ProcedureAction;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.translator.procedure.ProcedureTranslator;
import org.apache.cayenne.query.ProcedureQuery;

class MySQLProcedureAction
extends ProcedureAction {
    public MySQLProcedureAction(ProcedureQuery query, DataNode dataNode) {
        super(query, dataNode);
    }

    @Override
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        this.processedResultSets = 0;
        ProcedureTranslator transl = this.createTranslator(connection);
        try (CallableStatement statement = (CallableStatement)transl.createStatement();){
            boolean firstResult = statement.execute();
            this.readProcedureOutParameters(statement, observer);
            if (firstResult) {
                this.processResultSet(statement, observer);
            } else if (!this.processUpdate(statement, observer)) {
                return;
            }
            while (true) {
                if (statement.getMoreResults()) {
                    this.processResultSet(statement, observer);
                    continue;
                }
                if (!this.processUpdate(statement, observer)) break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResultSet(CallableStatement statement, OperationObserver observer) throws Exception {
        ResultSet rs = Objects.requireNonNull(statement.getResultSet());
        try {
            RowDescriptor descriptor = this.describeResultSet(rs, this.processedResultSets++);
            this.readResultSet(rs, descriptor, this.query, observer);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private boolean processUpdate(CallableStatement statement, OperationObserver observer) throws Exception {
        int updateCount = statement.getUpdateCount();
        if (updateCount == -1) {
            return false;
        }
        this.dataNode.getJdbcEventLogger().logUpdateCount(updateCount);
        observer.nextCount(this.query, updateCount);
        return true;
    }

    @Override
    protected ProcedureTranslator createTranslator(Connection connection) {
        MySQLProcedureTranslator translator = new MySQLProcedureTranslator();
        translator.setAdapter(this.dataNode.getAdapter());
        translator.setQuery(this.query);
        translator.setEntityResolver(this.dataNode.getEntityResolver());
        translator.setConnection(connection);
        translator.setJdbcEventLogger(this.dataNode.getJdbcEventLogger());
        return translator;
    }

    static class MySQLProcedureTranslator
    extends ProcedureTranslator {
        MySQLProcedureTranslator() {
        }

        @Override
        protected String createSqlString() {
            Object sql = super.createSqlString();
            if (((String)sql).endsWith("}") && !((String)sql).endsWith(")}")) {
                sql = ((String)sql).substring(0, ((String)sql).length() - 1) + "()}";
            }
            return sql;
        }
    }
}

