/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.LikeExpressionHelper;
import org.apache.cayenne.exp.parser.ASTAdd;
import org.apache.cayenne.exp.parser.ASTAll;
import org.apache.cayenne.exp.parser.ASTAnd;
import org.apache.cayenne.exp.parser.ASTAny;
import org.apache.cayenne.exp.parser.ASTBetween;
import org.apache.cayenne.exp.parser.ASTBitwiseAnd;
import org.apache.cayenne.exp.parser.ASTBitwiseLeftShift;
import org.apache.cayenne.exp.parser.ASTBitwiseNot;
import org.apache.cayenne.exp.parser.ASTBitwiseOr;
import org.apache.cayenne.exp.parser.ASTBitwiseRightShift;
import org.apache.cayenne.exp.parser.ASTBitwiseXor;
import org.apache.cayenne.exp.parser.ASTCaseWhen;
import org.apache.cayenne.exp.parser.ASTDbIdPath;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTDivide;
import org.apache.cayenne.exp.parser.ASTElse;
import org.apache.cayenne.exp.parser.ASTEnclosingObject;
import org.apache.cayenne.exp.parser.ASTEqual;
import org.apache.cayenne.exp.parser.ASTExists;
import org.apache.cayenne.exp.parser.ASTFalse;
import org.apache.cayenne.exp.parser.ASTFullObject;
import org.apache.cayenne.exp.parser.ASTGreater;
import org.apache.cayenne.exp.parser.ASTGreaterOrEqual;
import org.apache.cayenne.exp.parser.ASTIn;
import org.apache.cayenne.exp.parser.ASTLess;
import org.apache.cayenne.exp.parser.ASTLessOrEqual;
import org.apache.cayenne.exp.parser.ASTLike;
import org.apache.cayenne.exp.parser.ASTLikeIgnoreCase;
import org.apache.cayenne.exp.parser.ASTList;
import org.apache.cayenne.exp.parser.ASTMultiply;
import org.apache.cayenne.exp.parser.ASTNegate;
import org.apache.cayenne.exp.parser.ASTNot;
import org.apache.cayenne.exp.parser.ASTNotBetween;
import org.apache.cayenne.exp.parser.ASTNotEqual;
import org.apache.cayenne.exp.parser.ASTNotExists;
import org.apache.cayenne.exp.parser.ASTNotIn;
import org.apache.cayenne.exp.parser.ASTNotLike;
import org.apache.cayenne.exp.parser.ASTNotLikeIgnoreCase;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.ASTOr;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.ASTSubquery;
import org.apache.cayenne.exp.parser.ASTSubtract;
import org.apache.cayenne.exp.parser.ASTThen;
import org.apache.cayenne.exp.parser.ASTTrue;
import org.apache.cayenne.exp.parser.ASTWhen;
import org.apache.cayenne.exp.parser.ExpressionParser;
import org.apache.cayenne.exp.parser.ExpressionParserTokenManager;
import org.apache.cayenne.exp.parser.JavaCharStream;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.query.ColumnSelect;
import org.apache.cayenne.query.FluentSelect;

public class ExpressionFactory {
    public static final char SPLIT_SEPARATOR = '|';
    private static Constructor<? extends SimpleNode>[] typeLookup;
    private static volatile int autoAliasId;
    private static final int PARSE_BUFFER_MAX_SIZE = 4096;

    public static Expression expressionOfType(int type) {
        if (type < 0 || type >= typeLookup.length) {
            throw new ExpressionException("Bad expression type: " + type, new Object[0]);
        }
        if (typeLookup[type] == null) {
            throw new ExpressionException("Bad expression type: " + type, new Object[0]);
        }
        try {
            return typeLookup[type].newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new ExpressionException("Error creating expression", (Throwable)ex, new Object[0]);
        }
    }

    protected static Object wrapPathOperand(Object op) {
        if (op instanceof Collection) {
            return new ASTList((Collection)op);
        }
        if (op instanceof Object[]) {
            return new ASTList((Object[])op);
        }
        return op;
    }

    public static Expression matchAnyDbExp(Map<String, ?> map, int pairType) {
        List<Expression> pairs = ExpressionFactory.makeDbPathPairs(map, pairType);
        return ExpressionFactory.joinExp(1, pairs);
    }

    public static Expression matchAllDbExp(Map<String, ?> map, int pairType) {
        List<Expression> pairs = ExpressionFactory.makeDbPathPairs(map, pairType);
        return ExpressionFactory.joinExp(0, pairs);
    }

    private static List<Expression> makeDbPathPairs(Map<String, ?> map, int pairType) {
        ArrayList<Expression> pairs = new ArrayList<Expression>(map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Expression exp = ExpressionFactory.expressionOfType(pairType);
            exp.setOperand(0, new ASTDbPath(entry.getKey()));
            exp.setOperand(1, ExpressionFactory.wrapPathOperand(entry.getValue()));
            pairs.add(exp);
        }
        return pairs;
    }

    public static Expression matchAnyExp(Map<String, ?> map, int pairType) {
        List<Expression> pairs = ExpressionFactory.makeObjPathPairs(map, pairType);
        return ExpressionFactory.joinExp(1, pairs);
    }

    public static Expression matchAllExp(Map<String, ?> map, int pairType) {
        List<Expression> pairs = ExpressionFactory.makeObjPathPairs(map, pairType);
        return ExpressionFactory.joinExp(0, pairs);
    }

    private static List<Expression> makeObjPathPairs(Map<String, ?> map, int pairType) {
        ArrayList<Expression> pairs = new ArrayList<Expression>(map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Expression exp = ExpressionFactory.expressionOfType(pairType);
            exp.setOperand(0, new ASTObjPath(entry.getKey()));
            exp.setOperand(1, ExpressionFactory.wrapPathOperand(entry.getValue()));
            pairs.add(exp);
        }
        return pairs;
    }

    public static Expression matchAllExp(String path, Collection<?> values) {
        if (values == null) {
            throw new NullPointerException("Null values collection");
        }
        if (values.size() == 0) {
            return new ASTTrue();
        }
        return ExpressionFactory.matchAllExp(path, values.toArray());
    }

    public static Expression matchAllExp(String path, Object ... values) {
        Function<String, ASTPath> pathProvider;
        if (values == null) {
            throw new NullPointerException("Null values collection");
        }
        if (values.length == 0) {
            return new ASTTrue();
        }
        if (path.startsWith("db:")) {
            pathProvider = ASTDbPath::new;
            path = path.substring("db:".length());
        } else {
            pathProvider = ASTObjPath::new;
        }
        int split = path.indexOf(124);
        ArrayList<Expression> matches = new ArrayList<Expression>(values.length);
        if (split >= 0 && split < path.length() - 1) {
            int splitEnd = path.indexOf(".", split + 1);
            String beforeSplit = split > 0 ? path.substring(0, split) : "";
            String afterSplit = splitEnd > 0 ? "." + path.substring(splitEnd + 1) : "";
            String aliasBase = "split" + autoAliasId++ + "_";
            String splitChunk = splitEnd > 0 ? path.substring(split + 1, splitEnd) : path.substring(split + 1);
            path = split == 0 ? path.substring(1) : path.replace('|', '.');
            int i = 0;
            for (Object value : values) {
                String alias = aliasBase + i;
                String aliasedPath = beforeSplit + alias + afterSplit;
                ++i;
                ASTPath pathExp = pathProvider.apply(aliasedPath);
                pathExp.setPathAliases(Collections.singletonMap(alias, splitChunk));
                matches.add(new ASTEqual(pathExp, value));
            }
        } else {
            for (Object value : values) {
                matches.add(new ASTEqual(pathProvider.apply(path), value));
            }
        }
        return ExpressionFactory.joinExp(0, matches);
    }

    public static Expression matchDbExp(String pathSpec, Object value) {
        return new ASTEqual(new ASTDbPath(pathSpec), value);
    }

    public static Expression noMatchDbExp(String pathSpec, Object value) {
        return new ASTNotEqual(new ASTDbPath(pathSpec), value);
    }

    public static Expression matchExp(String pathSpec, Object value) {
        return ExpressionFactory.matchExp(new ASTObjPath(pathSpec), value);
    }

    public static Expression matchExp(Expression exp, Object value) {
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTEqual((SimpleNode)exp, value);
    }

    public static Expression noMatchExp(String pathSpec, Object value) {
        return ExpressionFactory.noMatchExp(new ASTObjPath(pathSpec), value);
    }

    public static Expression noMatchExp(Expression exp, Object value) {
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTNotEqual((SimpleNode)exp, value);
    }

    public static Expression matchDbIdExp(String pathSpec, Object value) {
        return ExpressionFactory.matchExp(new ASTDbIdPath(pathSpec), value);
    }

    public static Expression noMatchDbIdExp(String pathSpec, Object value) {
        return ExpressionFactory.noMatchExp(new ASTDbIdPath(pathSpec), value);
    }

    public static Expression lessExp(String pathSpec, Object value) {
        return ExpressionFactory.lessExp(new ASTObjPath(pathSpec), value);
    }

    public static Expression lessExp(Expression exp, Object value) {
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTLess((SimpleNode)exp, value);
    }

    public static Expression lessDbExp(String pathSpec, Object value) {
        return new ASTLess(new ASTDbPath(pathSpec), value);
    }

    public static Expression lessOrEqualExp(String pathSpec, Object value) {
        return ExpressionFactory.lessOrEqualExp(new ASTObjPath(pathSpec), value);
    }

    public static Expression lessOrEqualExp(Expression exp, Object value) {
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTLessOrEqual((SimpleNode)exp, value);
    }

    public static Expression lessOrEqualDbExp(String pathSpec, Object value) {
        return new ASTLessOrEqual(new ASTDbPath(pathSpec), value);
    }

    public static Expression greaterExp(String pathSpec, Object value) {
        return ExpressionFactory.greaterExp(new ASTObjPath(pathSpec), value);
    }

    public static Expression greaterExp(Expression exp, Object value) {
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTGreater((SimpleNode)exp, value);
    }

    public static Expression greaterDbExp(String pathSpec, Object value) {
        return new ASTGreater(new ASTDbPath(pathSpec), value);
    }

    public static Expression greaterOrEqualExp(String pathSpec, Object value) {
        return ExpressionFactory.greaterOrEqualExp(new ASTObjPath(pathSpec), value);
    }

    public static Expression greaterOrEqualExp(Expression exp, Object value) {
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTGreaterOrEqual((SimpleNode)exp, value);
    }

    public static Expression greaterOrEqualDbExp(String pathSpec, Object value) {
        return new ASTGreaterOrEqual(new ASTDbPath(pathSpec), value);
    }

    public static Expression inExp(String pathSpec, Object ... values) {
        return ExpressionFactory.inExp((Expression)new ASTObjPath(pathSpec), values);
    }

    public static Expression inExp(Expression exp, Object ... values) {
        if (values.length == 0) {
            return new ASTFalse();
        }
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTIn((SimpleNode)exp, new ASTList(values));
    }

    public static Expression inDbExp(String pathSpec, Object ... values) {
        if (values.length == 0) {
            return new ASTFalse();
        }
        return new ASTIn(new ASTDbPath(pathSpec), new ASTList(values));
    }

    public static Expression inExp(String pathSpec, Collection<?> values) {
        return ExpressionFactory.inExp((Expression)new ASTObjPath(pathSpec), values);
    }

    public static Expression inDbIdExp(String pathSpec, Object ... values) {
        if (values.length == 0) {
            return new ASTFalse();
        }
        return new ASTIn(new ASTDbIdPath(pathSpec), new ASTList(values));
    }

    public static Expression inExp(Expression exp, Collection<?> values) {
        if (values.isEmpty()) {
            return new ASTFalse();
        }
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTIn((SimpleNode)exp, new ASTList(values));
    }

    public static Expression inDbExp(String pathSpec, Collection<?> values) {
        if (values.isEmpty()) {
            return new ASTFalse();
        }
        return new ASTIn(new ASTDbPath(pathSpec), new ASTList(values));
    }

    public static Expression inDbIdExp(String pathSpec, Collection<?> values) {
        if (values.isEmpty()) {
            return new ASTFalse();
        }
        return new ASTIn(new ASTDbIdPath(pathSpec), new ASTList(values));
    }

    public static Expression notInExp(String pathSpec, Collection<?> values) {
        return ExpressionFactory.notInExp((Expression)new ASTObjPath(pathSpec), values);
    }

    public static Expression notInExp(Expression exp, Collection<?> values) {
        if (values.isEmpty()) {
            return new ASTTrue();
        }
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTNotIn((SimpleNode)exp, new ASTList(values));
    }

    public static Expression notInDbExp(String pathSpec, Collection<?> values) {
        if (values.isEmpty()) {
            return new ASTTrue();
        }
        return new ASTNotIn(new ASTDbPath(pathSpec), new ASTList(values));
    }

    public static Expression notInDbIdExp(String pathSpec, Collection<?> values) {
        if (values.isEmpty()) {
            return new ASTTrue();
        }
        return new ASTNotIn(new ASTDbIdPath(pathSpec), new ASTList(values));
    }

    public static Expression notInExp(String pathSpec, Object ... values) {
        return ExpressionFactory.notInExp((Expression)new ASTObjPath(pathSpec), values);
    }

    public static Expression notInExp(Expression exp, Object ... values) {
        if (values.length == 0) {
            return new ASTTrue();
        }
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTNotIn((SimpleNode)exp, new ASTList(values));
    }

    public static Expression notInDbExp(String pathSpec, Object ... values) {
        if (values.length == 0) {
            return new ASTTrue();
        }
        return new ASTNotIn(new ASTDbPath(pathSpec), new ASTList(values));
    }

    public static Expression notInDbIdExp(String pathSpec, Object ... values) {
        if (values.length == 0) {
            return new ASTTrue();
        }
        return new ASTNotIn(new ASTDbIdPath(pathSpec), new ASTList(values));
    }

    public static Expression betweenExp(String pathSpec, Object value1, Object value2) {
        return ExpressionFactory.betweenExp(new ASTObjPath(pathSpec), value1, value2);
    }

    public static Expression betweenExp(Expression exp, Object value1, Object value2) {
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTBetween((SimpleNode)exp, value1, value2);
    }

    public static Expression betweenDbExp(String pathSpec, Object value1, Object value2) {
        return new ASTBetween(new ASTDbPath(pathSpec), value1, value2);
    }

    public static Expression notBetweenExp(String pathSpec, Object value1, Object value2) {
        return ExpressionFactory.notBetweenExp(new ASTObjPath(pathSpec), value1, value2);
    }

    public static Expression notBetweenExp(Expression exp, Object value1, Object value2) {
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTNotBetween((SimpleNode)exp, value1, value2);
    }

    public static Expression notBetweenDbExp(String pathSpec, Object value1, Object value2) {
        return new ASTNotBetween(new ASTDbPath(pathSpec), value1, value2);
    }

    public static Expression likeExp(String pathSpec, Object value) {
        return ExpressionFactory.likeExpInternal(pathSpec, value, '\u0000');
    }

    public static Expression likeExp(Expression exp, Object value) {
        return ExpressionFactory.likeExpInternal(exp, value, '\u0000');
    }

    public static Expression likeExp(String pathSpec, Object value, char escapeChar) {
        return ExpressionFactory.likeExpInternal(pathSpec, value, escapeChar);
    }

    public static Expression likeExp(Expression exp, Object value, char escapeChar) {
        return ExpressionFactory.likeExpInternal(exp, value, escapeChar);
    }

    static ASTLike likeExpInternal(String pathSpec, Object value, char escapeChar) {
        return ExpressionFactory.likeExpInternal(new ASTObjPath(pathSpec), value, escapeChar);
    }

    static ASTLike likeExpInternal(Expression expression, Object value, char escapeChar) {
        if (!(expression instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTLike((SimpleNode)expression, value, escapeChar);
    }

    public static Expression likeDbExp(String pathSpec, Object value) {
        return new ASTLike(new ASTDbPath(pathSpec), value);
    }

    public static Expression likeDbExp(String pathSpec, Object value, char escapeChar) {
        return new ASTLike(new ASTDbPath(pathSpec), value, escapeChar);
    }

    public static Expression notLikeExp(String pathSpec, Object value) {
        return ExpressionFactory.notLikeExp(new ASTObjPath(pathSpec), value);
    }

    public static Expression notLikeExp(Expression exp, Object value) {
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTNotLike((SimpleNode)exp, value);
    }

    public static Expression notLikeExp(String pathSpec, Object value, char escapeChar) {
        return ExpressionFactory.notLikeExp(new ASTObjPath(pathSpec), value, escapeChar);
    }

    public static Expression notLikeExp(Expression exp, Object value, char escapeChar) {
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTNotLike((SimpleNode)exp, value, escapeChar);
    }

    public static Expression notLikeDbExp(String pathSpec, Object value) {
        return new ASTNotLike(new ASTDbPath(pathSpec), value);
    }

    public static Expression notLikeDbExp(String pathSpec, Object value, char escapeChar) {
        return new ASTNotLike(new ASTDbPath(pathSpec), value, escapeChar);
    }

    public static Expression likeIgnoreCaseExp(String pathSpec, Object value) {
        return ExpressionFactory.likeIgnoreCaseExpInternal(pathSpec, value, '\u0000');
    }

    public static Expression likeIgnoreCaseExp(Expression exp, Object value) {
        return ExpressionFactory.likeIgnoreCaseExp(exp, value, '\u0000');
    }

    public static Expression likeIgnoreCaseExp(String pathSpec, Object value, char escapeChar) {
        return ExpressionFactory.likeIgnoreCaseExpInternal(pathSpec, value, escapeChar);
    }

    static ASTLikeIgnoreCase likeIgnoreCaseExpInternal(String pathSpec, Object value, char escapeChar) {
        return ExpressionFactory.likeIgnoreCaseExp(new ASTObjPath(pathSpec), value, escapeChar);
    }

    static ASTLikeIgnoreCase likeIgnoreCaseExp(Expression exp, Object value, char escapeChar) {
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTLikeIgnoreCase((SimpleNode)exp, value, escapeChar);
    }

    public static Expression likeIgnoreCaseDbExp(String pathSpec, Object value) {
        return new ASTLikeIgnoreCase(new ASTDbPath(pathSpec), value);
    }

    public static Expression likeIgnoreCaseDbExp(String pathSpec, Object value, char escapeChar) {
        return new ASTLikeIgnoreCase(new ASTDbPath(pathSpec), value, escapeChar);
    }

    public static Expression notLikeIgnoreCaseExp(String pathSpec, Object value) {
        return ExpressionFactory.notLikeIgnoreCaseExp(new ASTObjPath(pathSpec), value);
    }

    public static Expression notLikeIgnoreCaseExp(Expression exp, Object value) {
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTNotLikeIgnoreCase((SimpleNode)exp, value);
    }

    public static Expression notLikeIgnoreCaseExp(String pathSpec, Object value, char escapeChar) {
        return ExpressionFactory.notLikeIgnoreCaseExp(new ASTObjPath(pathSpec), value, escapeChar);
    }

    public static Expression notLikeIgnoreCaseExp(Expression exp, Object value, char escapeChar) {
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTNotLikeIgnoreCase((SimpleNode)exp, value, escapeChar);
    }

    public static Expression notLikeIgnoreCaseDbExp(String pathSpec, Object value) {
        return new ASTNotLikeIgnoreCase(new ASTDbPath(pathSpec), value);
    }

    public static Expression notLikeIgnoreCaseDbExp(String pathSpec, Object value, char escapeChar) {
        return new ASTNotLikeIgnoreCase(new ASTDbPath(pathSpec), value, escapeChar);
    }

    public static Expression containsExp(String pathSpec, String value) {
        ASTLike like = ExpressionFactory.likeExpInternal(pathSpec, (Object)value, '\u0000');
        LikeExpressionHelper.toContains(like);
        return like;
    }

    public static Expression containsExp(Expression exp, String value) {
        ASTLike like = ExpressionFactory.likeExpInternal(exp, (Object)value, '\u0000');
        LikeExpressionHelper.toContains(like);
        return like;
    }

    public static Expression startsWithExp(String pathSpec, String value) {
        ASTLike like = ExpressionFactory.likeExpInternal(pathSpec, (Object)value, '\u0000');
        LikeExpressionHelper.toStartsWith(like);
        return like;
    }

    public static Expression startsWithExp(Expression exp, String value) {
        ASTLike like = ExpressionFactory.likeExpInternal(exp, (Object)value, '\u0000');
        LikeExpressionHelper.toStartsWith(like);
        return like;
    }

    public static Expression endsWithExp(String pathSpec, String value) {
        ASTLike like = ExpressionFactory.likeExpInternal(pathSpec, (Object)value, '\u0000');
        LikeExpressionHelper.toEndsWith(like);
        return like;
    }

    public static Expression endsWithExp(Expression exp, String value) {
        ASTLike like = ExpressionFactory.likeExpInternal(exp, (Object)value, '\u0000');
        LikeExpressionHelper.toEndsWith(like);
        return like;
    }

    public static Expression containsIgnoreCaseExp(String pathSpec, String value) {
        ASTLikeIgnoreCase like = ExpressionFactory.likeIgnoreCaseExpInternal(pathSpec, value, '\u0000');
        LikeExpressionHelper.toContains(like);
        return like;
    }

    public static Expression containsIgnoreCaseExp(Expression exp, String value) {
        ASTLikeIgnoreCase like = ExpressionFactory.likeIgnoreCaseExp(exp, (Object)value, '\u0000');
        LikeExpressionHelper.toContains(like);
        return like;
    }

    public static Expression startsWithIgnoreCaseExp(String pathSpec, String value) {
        ASTLikeIgnoreCase like = ExpressionFactory.likeIgnoreCaseExpInternal(pathSpec, value, '\u0000');
        LikeExpressionHelper.toStartsWith(like);
        return like;
    }

    public static Expression startsWithIgnoreCaseExp(Expression exp, String value) {
        ASTLikeIgnoreCase like = ExpressionFactory.likeIgnoreCaseExp(exp, (Object)value, '\u0000');
        LikeExpressionHelper.toStartsWith(like);
        return like;
    }

    public static Expression endsWithIgnoreCaseExp(String pathSpec, String value) {
        ASTLikeIgnoreCase like = ExpressionFactory.likeIgnoreCaseExpInternal(pathSpec, value, '\u0000');
        LikeExpressionHelper.toEndsWith(like);
        return like;
    }

    public static Expression endsWithIgnoreCaseExp(Expression exp, String value) {
        ASTLikeIgnoreCase like = ExpressionFactory.likeIgnoreCaseExp(exp, (Object)value, '\u0000');
        LikeExpressionHelper.toEndsWith(like);
        return like;
    }

    public static Expression pathExp(String pathSpec) {
        return new ASTObjPath(pathSpec);
    }

    public static Expression pathExp(CayennePath path) {
        return new ASTObjPath(path);
    }

    public static Expression dbPathExp(String pathSpec) {
        return new ASTDbPath(pathSpec);
    }

    public static Expression dbPathExp(CayennePath path) {
        return new ASTDbPath(path);
    }

    public static Expression dbIdPathExp(String pathSpec) {
        return new ASTDbIdPath(pathSpec);
    }

    public static Expression dbIdPathExp(CayennePath pathSpec) {
        return new ASTDbIdPath(pathSpec);
    }

    public static Expression expTrue() {
        return new ASTTrue();
    }

    public static Expression expFalse() {
        return new ASTFalse();
    }

    public static Expression joinExp(int type, Collection<Expression> expressions) {
        int len = expressions.size();
        if (len == 0) {
            return null;
        }
        return ExpressionFactory.joinExp(type, expressions.toArray(new Expression[len]));
    }

    public static Expression joinExp(int type, Expression ... expressions) {
        int len;
        int n = len = expressions != null ? expressions.length : 0;
        if (len == 0) {
            return null;
        }
        Expression currentExp = expressions[0];
        if (len == 1) {
            return currentExp;
        }
        Expression exp = ExpressionFactory.expressionOfType(type);
        for (int i = 0; i < len; ++i) {
            exp.setOperand(i, expressions[i]);
        }
        return exp;
    }

    public static Expression matchExp(Persistent object) {
        return ExpressionFactory.matchAllDbExp(object.getObjectId().getIdSnapshot(), 3);
    }

    public static Expression matchAnyExp(List<? extends Persistent> objects) {
        if (objects == null || objects.size() == 0) {
            return ExpressionFactory.expFalse();
        }
        return ExpressionFactory.matchAnyExp(objects.toArray(new Persistent[objects.size()]));
    }

    public static Expression matchAnyExp(Persistent ... objects) {
        if (objects == null || objects.length == 0) {
            return ExpressionFactory.expFalse();
        }
        ArrayList<Expression> pairs = new ArrayList<Expression>(objects.length);
        for (Persistent object : objects) {
            pairs.add(ExpressionFactory.matchExp(object));
        }
        return ExpressionFactory.joinExp(1, pairs);
    }

    public static Expression fullObjectExp() {
        return new ASTFullObject();
    }

    public static Expression fullObjectExp(Expression exp) {
        return new ASTFullObject(exp);
    }

    public static Expression enclosingObjectExp(Expression exp) {
        return new ASTEnclosingObject(exp);
    }

    public static Expression and(Collection<Expression> expressions) {
        return ExpressionFactory.joinExp(0, expressions);
    }

    public static Expression and(Expression ... expressions) {
        return ExpressionFactory.joinExp(0, expressions);
    }

    public static Expression or(Collection<Expression> expressions) {
        return ExpressionFactory.joinExp(1, expressions);
    }

    public static Expression or(Expression ... expressions) {
        return ExpressionFactory.joinExp(1, expressions);
    }

    public static Expression exp(String expressionString, Object ... parameters) {
        Expression e = ExpressionFactory.fromString(expressionString);
        if (parameters != null && parameters.length > 0) {
            e.inPlaceParamsArray(parameters);
        }
        return e;
    }

    public static Expression wrapScalarValue(Object value) {
        return new ASTScalar(value);
    }

    private static Expression fromString(String expressionString) {
        if (expressionString == null) {
            throw new NullPointerException("Null expression string.");
        }
        int bufferSize = expressionString.length() > 4096 ? 4096 : expressionString.length() + 1;
        StringReader reader = new StringReader(expressionString);
        JavaCharStream stream = new JavaCharStream(reader, 1, 1, bufferSize);
        ExpressionParserTokenManager tm = new ExpressionParserTokenManager(stream);
        ExpressionParser parser = new ExpressionParser(tm);
        try {
            return parser.expression();
        }
        catch (Throwable th) {
            String message = th.getMessage();
            throw new ExpressionException("%s", th, message != null ? message : "");
        }
    }

    public static Expression exists(FluentSelect<?, ?> subQuery) {
        return new ASTExists(new ASTSubquery(subQuery));
    }

    public static Expression exists(Expression exp) {
        return new ASTExists(exp);
    }

    public static Expression notExists(FluentSelect<?, ?> subQuery) {
        return new ASTNotExists(new ASTSubquery(subQuery));
    }

    public static Expression notExists(Expression exp) {
        return new ASTNotExists(exp);
    }

    public static Expression inExp(Expression exp, ColumnSelect<?> subQuery) {
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTIn((SimpleNode)exp, new ASTSubquery(subQuery));
    }

    public static Expression notInExp(Expression exp, ColumnSelect<?> subQuery) {
        if (!(exp instanceof SimpleNode)) {
            throw new IllegalArgumentException("exp should be instance of SimpleNode");
        }
        return new ASTNotIn((SimpleNode)exp, new ASTSubquery(subQuery));
    }

    public static Expression all(ColumnSelect<?> subquery) {
        return new ASTAll(new ASTSubquery(subquery));
    }

    public static Expression any(ColumnSelect<?> subquery) {
        return new ASTAny(new ASTSubquery(subquery));
    }

    public static Expression caseWhen(List<Expression> whenExp, List<Expression> thenExp) {
        return ExpressionFactory.caseWhen(whenExp, thenExp, null);
    }

    public static Expression caseWhen(List<Expression> whenExp, List<Expression> thenExp, Expression caseDefault) {
        if (whenExp.size() != thenExp.size()) {
            throw new ExpressionException("Each member in the \"When\"-\"Then\" pairs must be defined", new Object[0]);
        }
        ArrayList<SimpleNode> expressions = new ArrayList<SimpleNode>();
        for (int i = 0; i < whenExp.size(); ++i) {
            expressions.add(new ASTWhen(whenExp.get(i)));
            expressions.add(new ASTThen(thenExp.get(i)));
        }
        boolean hasDefault = false;
        if (caseDefault != null) {
            expressions.add(new ASTElse(caseDefault));
            hasDefault = true;
        }
        return new ASTCaseWhen(hasDefault, expressions.toArray(new Expression[0]));
    }

    static {
        int[] allTypes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 16, 17, 18, 19, 20, 26, 27, 28, 35, 36, 37, 38, 21, 22, 39, 40, 41, 42, 43, 44};
        int max = 0;
        for (int type : allTypes) {
            if (type > 500) {
                throw new RuntimeException("Types values are too big: " + type);
            }
            if (type < 0) {
                throw new RuntimeException("Types values are too small: " + type);
            }
            if (type <= max) continue;
            max = type;
        }
        Constructor[] lookupTable = new Constructor[max + 1];
        typeLookup = lookupTable;
        try {
            ExpressionFactory.typeLookup[0] = ASTAnd.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[1] = ASTOr.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[9] = ASTBetween.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[35] = ASTNotBetween.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[3] = ASTEqual.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[4] = ASTNotEqual.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[5] = ASTLess.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[6] = ASTGreater.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[7] = ASTLessOrEqual.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[8] = ASTGreaterOrEqual.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[10] = ASTIn.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[36] = ASTNotIn.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[11] = ASTLike.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[12] = ASTLikeIgnoreCase.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[37] = ASTNotLike.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[38] = ASTNotLikeIgnoreCase.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[16] = ASTAdd.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[17] = ASTSubtract.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[18] = ASTMultiply.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[19] = ASTDivide.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[2] = ASTNot.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[20] = ASTNegate.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[26] = ASTObjPath.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[27] = ASTDbPath.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[28] = ASTList.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[21] = ASTTrue.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[22] = ASTFalse.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[39] = ASTBitwiseNot.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[41] = ASTBitwiseOr.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[40] = ASTBitwiseAnd.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[42] = ASTBitwiseXor.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[43] = ASTBitwiseLeftShift.class.getDeclaredConstructor(new Class[0]);
            ExpressionFactory.typeLookup[44] = ASTBitwiseRightShift.class.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new ExpressionException("Wrong expression type found", (Throwable)ex, new Object[0]);
        }
    }
}

