/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.function.Function;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTExists;
import org.apache.cayenne.exp.parser.ASTNot;
import org.apache.cayenne.exp.parser.ASTNotExists;
import org.apache.cayenne.exp.parser.ASTWhen;
import org.apache.cayenne.exp.parser.ConditionNode;
import org.apache.cayenne.exp.parser.Node;
import org.apache.cayenne.exp.parser.SimpleNode;

public abstract class AggregateConditionNode
extends SimpleNode {
    private static final long serialVersionUID = -636699350691988809L;

    AggregateConditionNode(int i) {
        super(i);
    }

    @Override
    protected boolean pruneNodeForPrunedChild(Object prunedChild) {
        return false;
    }

    @Override
    protected Object transformExpression(Function<Object, Object> transformer) {
        Object transformed = super.transformExpression(transformer);
        if (!(transformed instanceof AggregateConditionNode)) {
            return transformed;
        }
        AggregateConditionNode condition = (AggregateConditionNode)transformed;
        switch (condition.getOperandCount()) {
            case 1: {
                if (condition instanceof ASTNot || condition instanceof ASTWhen) {
                    return condition;
                }
                return condition.getOperand(0);
            }
            case 0: {
                return PRUNED_NODE;
            }
        }
        return condition;
    }

    @Override
    protected boolean isValidParent(Node n) {
        return n instanceof AggregateConditionNode || n instanceof ASTExists || n instanceof ASTNotExists;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (!(n instanceof ConditionNode) && !(n instanceof AggregateConditionNode)) {
            String label = n instanceof SimpleNode ? ((SimpleNode)n).expName() : String.valueOf(n);
            throw new ExpressionException(this.expName() + ": invalid child - " + label, new Object[0]);
        }
        super.jjtAddChild(n, i);
    }

    @Override
    public Expression exists() {
        return ExpressionFactory.exists(this);
    }

    @Override
    public Expression notExists() {
        return ExpressionFactory.notExists(this);
    }
}

