/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.ComparableProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.ColumnSelectMetadata;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.QueryMetadata;

public class ColumnSelect<T>
extends FluentSelect<T, ColumnSelect<T>> {
    protected Collection<Property<?>> columns;
    protected boolean singleColumn = true;

    protected ColumnSelect() {
    }

    protected ColumnSelect(ObjectSelect<T> select) {
        this.entityType = select.entityType;
        this.entityName = select.entityName;
        this.dbEntityName = select.dbEntityName;
        this.where = select.where;
        this.having = select.having;
        this.orderings = select.orderings;
        this.metaData.copyFromInfo(select.metaData);
    }

    @Override
    protected ColumnSelectMetadata createMetadata() {
        return new ColumnSelectMetadata();
    }

    public ColumnSelect<Object[]> columns(Property<?> ... properties) {
        if (properties.length == 0) {
            throw new IllegalArgumentException("properties must contain at least one element");
        }
        if (this.columns == null) {
            this.columns = new ArrayList(properties.length);
        }
        Collections.addAll(this.columns, properties);
        this.singleColumn = false;
        return (ColumnSelect)this.castSelf();
    }

    public ColumnSelect<Object[]> columns(Collection<Property<?>> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is null");
        }
        if (properties.isEmpty()) {
            throw new IllegalArgumentException("properties must contain at least one element");
        }
        if (this.columns == null) {
            this.columns = new ArrayList(properties.size());
        }
        this.columns.addAll(properties);
        this.singleColumn = false;
        return (ColumnSelect)this.castSelf();
    }

    protected <E> ColumnSelect<E> column(Property<E> property) {
        if (this.columns == null) {
            this.columns = new ArrayList(1);
        } else {
            this.columns.clear();
        }
        this.columns.add(property);
        return (ColumnSelect)this.castSelf();
    }

    public ColumnSelect<Object[]> count() {
        return this.columns(PropertyFactory.COUNT);
    }

    public ColumnSelect<Object[]> count(BaseProperty<?> property) {
        return this.columns(property.count());
    }

    public ColumnSelect<Object[]> min(ComparableProperty<?> property) {
        return this.columns(property.min());
    }

    public ColumnSelect<Object[]> max(ComparableProperty<?> property) {
        return this.columns(property.max());
    }

    public ColumnSelect<Object[]> avg(NumericProperty<?> property) {
        return this.columns(property.avg());
    }

    public <E extends Number> ColumnSelect<Object[]> sum(NumericProperty<E> property) {
        return this.columns(property.sum());
    }

    public <E> ColumnSelect<Object[]> aggregate(BaseProperty<E> property, String function, Class<E> type) {
        return this.columns(property.aggregate(function, type));
    }

    public ColumnSelect<T> having(Expression expression) {
        this.havingExpressionIsActive = true;
        return (ColumnSelect)this.and(expression);
    }

    public ColumnSelect<T> having(String expressionString, Object ... parameters) {
        this.havingExpressionIsActive = true;
        return (ColumnSelect)this.and(ExpressionFactory.exp(expressionString, parameters));
    }

    public ColumnSelect<T> distinct() {
        this.getBaseMetaData().setSuppressingDistinct(false);
        this.distinct = true;
        return this;
    }

    public ColumnSelect<T> suppressDistinct() {
        this.getBaseMetaData().setSuppressingDistinct(true);
        this.distinct = false;
        return this;
    }

    @Override
    public Collection<Property<?>> getColumns() {
        return this.columns;
    }

    @Override
    public T selectFirst(ObjectContext context) {
        return context.selectFirst(this.limit(1));
    }

    boolean isSingleColumn() {
        return this.singleColumn;
    }

    @Override
    public QueryMetadata getMetaData(EntityResolver resolver) {
        Object root = this.resolveRoot(resolver);
        this.getBaseMetaData().resolve(root, resolver, this);
        return this.metaData;
    }

    @Override
    protected ColumnSelectMetadata getBaseMetaData() {
        return (ColumnSelectMetadata)this.metaData;
    }

    public <E> ColumnSelect<E> map(Function<T, E> mapper) {
        this.getBaseMetaData().setResultMapper(mapper);
        return (ColumnSelect)this.castSelf();
    }
}

