/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class ClassMisc {
    private static void addSuperClasses(Set<Class<?>> superSet, Class<?> baseClass) {
        Class<?> clazz;
        for (clazz = baseClass.getSuperclass(); clazz != null && !Object.class.equals(clazz); clazz = clazz.getSuperclass()) {
            if (!Modifier.isPublic(clazz.getModifiers())) continue;
            superSet.add(clazz);
        }
        for (clazz = baseClass; clazz != null && !Object.class.equals(clazz); clazz = clazz.getSuperclass()) {
            ClassMisc.addSuperInterfaces(superSet, clazz);
        }
    }

    private static void addSuperInterfaces(Set<Class<?>> superSet, Class<?> clazz) {
        for (Class<?> inter : clazz.getInterfaces()) {
            superSet.add(inter);
            ClassMisc.addSuperInterfaces(superSet, inter);
        }
    }

    public static Class<?> getCommonSuperClass(Class<?> baseClass, Class<?> other) {
        if (baseClass == null || other == null) {
            return null;
        }
        if (baseClass != Object.class && other != Object.class) {
            LinkedHashSet superSet = new LinkedHashSet();
            ClassMisc.addSuperClasses(superSet, baseClass);
            for (Class clazz : superSet) {
                if (!clazz.isAssignableFrom(other)) continue;
                return clazz;
            }
        }
        return Object.class;
    }

    public static Set<Class<?>> getSuperClasses(Class<?> baseClass, Class<?> ... otherClasses) {
        if (baseClass == null) {
            return Collections.emptySet();
        }
        LinkedHashSet superSet = new LinkedHashSet();
        ClassMisc.addSuperClasses(superSet, baseClass);
        if (otherClasses.length > 0) {
            for (Class<?> other : otherClasses) {
                Iterator superClass = superSet.iterator();
                while (superClass.hasNext()) {
                    if (((Class)superClass.next()).isAssignableFrom(other)) continue;
                    superClass.remove();
                }
                if (!superSet.isEmpty()) continue;
                return Collections.emptySet();
            }
        }
        return superSet;
    }

    private ClassMisc() {
    }
}

