/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import io.github.lukehutch.fastclasspathscanner.utils.SingletonMap;
import io.github.lukehutch.fastclasspathscanner.utils.WorkQueue;

class ClasspathRelativePathToElementMap
extends SingletonMap<ClasspathRelativePath, ClasspathElement>
implements AutoCloseable {
    private final boolean scanFiles;
    private final ScanSpec scanSpec;
    private final NestedJarHandler nestedJarHandler;
    private final InterruptionChecker interruptionChecker;
    private final LogNode log;
    private WorkQueue<ClasspathRelativePath> workQueue;

    ClasspathRelativePathToElementMap(boolean scanFiles, ScanSpec scanSpec, NestedJarHandler nestedJarHandler, InterruptionChecker interruptionChecker, LogNode log) {
        this.scanFiles = scanFiles;
        this.scanSpec = scanSpec;
        this.nestedJarHandler = nestedJarHandler;
        this.interruptionChecker = interruptionChecker;
        this.log = log;
    }

    public void setWorkQueue(WorkQueue<ClasspathRelativePath> workQueue) {
        this.workQueue = workQueue;
    }

    @Override
    public ClasspathElement newInstance(ClasspathRelativePath classpathElt) {
        return ClasspathElement.newInstance(classpathElt, this.scanFiles, this.scanSpec, this.nestedJarHandler, this.workQueue, this.interruptionChecker, this.log);
    }

    @Override
    public void close() throws Exception {
        for (ClasspathElement classpathElt : this.values()) {
            classpathElt.close();
        }
    }
}

