/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ToolTipUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import sun.swing.SwingUtilities2;

public class SmoothToolTip
extends JToolTip {
    private static final String UI_CLASS_ID = "SmoothToolTipUI";
    private boolean _settingUI;

    public SmoothToolTip() {
        this.setBorder(null);
        this.setOpaque(false);
    }

    @Override
    public final ToolTipUI getUI() {
        return (ToolTipUI)this.ui;
    }

    public final void setUI(ToolTipUI ui) {
        if (this._settingUI) {
            return;
        }
        if (this.ui != ui) {
            this._settingUI = true;
            try {
                super.setUI(ui);
            }
            finally {
                this._settingUI = false;
            }
        }
    }

    @Override
    public final void updateUI() {
        this.setUI(new SmoothToolTipUI());
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    @Override
    public void paintBorder(Graphics g) {
    }

    private static final class SmoothToolTipUI
    extends BasicToolTipUI {
        private SmoothToolTipUI() {
        }

        @Override
        public void update(Graphics g, JComponent c) {
            this.paint(g, c);
        }

        @Override
        public void paint(Graphics g, JComponent comp) {
            Font font = comp.getFont();
            FontMetrics metrics = SwingUtilities2.getFontMetrics(comp, g, font);
            Dimension size = comp.getSize();
            Color background = Color.YELLOW;
            Color transground = new Color(background.getRed(), background.getGreen(), background.getBlue(), 195);
            g.setColor(transground);
            g.fillRoundRect(0, 0, size.width, size.height, 6, 3);
            Color foreground = comp.getForeground();
            transground = new Color(foreground.getRed(), foreground.getGreen(), foreground.getBlue(), 195);
            g.setColor(transground);
            String tipText = ((JToolTip)comp).getTipText();
            if (tipText == null) {
                tipText = "";
            }
            Insets insets = comp.getInsets();
            RoundRectangle2D.Float paintTextR = new RoundRectangle2D.Float(insets.left + 3, insets.top, size.width - (insets.left + insets.right) - 6, size.height - (insets.top + insets.bottom), 10.0f, 10.0f);
            g.setFont(font);
            SwingUtilities2.drawString(comp, g, tipText, (int)paintTextR.getX(), (int)paintTextR.getY() + metrics.getAscent());
            transground = new Color(foreground.getRed(), foreground.getGreen(), foreground.getBlue(), 63);
            g.setColor(transground);
            g.drawRoundRect(0, 0, size.width - 1, size.height - 1, 10, 10);
        }
    }
}

