/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.dictionary.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.ctakes.gui.dictionary.umls.VocabularyStore;
import org.apache.log4j.Logger;

public final class HsqlUtil {
    private static final Logger LOGGER = Logger.getLogger((String)"HsqlUtil");
    public static final String URL_PREFIX = "jdbc:hsqldb:file:";

    private HsqlUtil() {
    }

    public static boolean createDatabase(Connection connection) {
        try {
            HsqlUtil.createTable(connection, "CUI_TERMS", "CUI BIGINT", "RINDEX INTEGER", "TCOUNT INTEGER", "TEXT VARCHAR(255)", "RWORD VARCHAR(48)");
            HsqlUtil.createIndex(connection, "CUI_TERMS", "RWORD");
            HsqlUtil.createTable(connection, "TUI", "CUI BIGINT", "TUI INTEGER");
            HsqlUtil.createIndex(connection, "TUI", "CUI");
            HsqlUtil.createTable(connection, "PREFTERM", "CUI BIGINT", "PREFTERM VARCHAR(511)");
            HsqlUtil.createIndex(connection, "PREFTERM", "CUI");
            for (String vocabulary : VocabularyStore.getInstance().getAllVocabularies()) {
                String jdbcClass = VocabularyStore.getInstance().getJdbcClass(vocabulary);
                String tableName = vocabulary.replace('.', '_').replace('-', '_');
                HsqlUtil.createTable(connection, tableName, "CUI BIGINT", tableName + " " + jdbcClass);
                HsqlUtil.createIndex(connection, tableName, "CUI");
            }
            HsqlUtil.executeStatement(connection, "SET WRITE_DELAY 10");
        }
        catch (SQLException sqlE) {
            LOGGER.error((Object)sqlE.getMessage());
            return false;
        }
        return true;
    }

    private static void createTable(Connection connection, String tableName, String ... fieldNames) throws SQLException {
        String fields = Arrays.stream(fieldNames).collect(Collectors.joining(","));
        String creator = "CREATE MEMORY TABLE " + tableName + "(" + fields + ")";
        HsqlUtil.executeStatement(connection, creator);
    }

    private static void createIndex(Connection connection, String tableName, String indexField) throws SQLException {
        String indexer = "CREATE INDEX IDX_" + tableName + " ON " + tableName + "(" + indexField + ")";
        HsqlUtil.executeStatement(connection, indexer);
    }

    private static void executeStatement(Connection connection, String command) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute(command);
        statement.close();
    }
}

