/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.dictionary.util;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public final class JdbcUtil {
    private static final Logger LOGGER = Logger.getLogger((String)"JdbcUtil");
    private static final String JDBC_DRIVER = "org.hsqldb.jdbcDriver";

    private JdbcUtil() {
    }

    public static void registerDriver() {
        try {
            Driver driver = (Driver)Class.forName(JDBC_DRIVER).newInstance();
            DriverManager.registerDriver(driver);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not register Driver org.hsqldb.jdbcDriver");
            LOGGER.error((Object)e.getMessage());
            System.exit(1);
        }
    }

    public static Connection createDatabaseConnection(String url, String user, String pass) {
        JdbcUtil.registerDriver();
        LOGGER.info((Object)("Connecting to " + url + " as " + user));
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(url, user, pass);
        }
        catch (SQLException sqlE) {
            LOGGER.error((Object)("Could not establish connection to " + url + " as " + user));
            LOGGER.error((Object)sqlE.getMessage());
            System.exit(1);
        }
        return connection;
    }

    public static String createRowInsertSql(String tableName, Enum ... fields) {
        String[] fieldNames = new String[fields.length];
        int i = 0;
        for (Enum field : fields) {
            fieldNames[i] = field.name();
            ++i;
        }
        return JdbcUtil.createRowInsertSql(tableName, fieldNames);
    }

    public static String createCodeInsertSql(String vocabulary) {
        return JdbcUtil.createRowInsertSql(vocabulary.toLowerCase().replace('.', '_').replace('-', '_'), "CUI", vocabulary);
    }

    public static String createRowInsertSql(String tableName, String ... fieldNames) {
        StringBuilder sb = new StringBuilder("insert into");
        sb.append(" ").append(tableName);
        sb.append(" (");
        for (String fieldName : fieldNames) {
            sb.append(fieldName).append(',');
        }
        sb.setLength(sb.length() - 1);
        sb.append(") ");
        sb.append(" values (");
        for (int i = 0; i < fieldNames.length - 1; ++i) {
            sb.append("?,");
        }
        sb.append("?)");
        return sb.toString();
    }
}

