/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.gui.component.DisablerPane;
import org.apache.ctakes.gui.component.LoggerPanel;
import org.apache.ctakes.gui.component.PositionedSplitPane;
import org.apache.ctakes.gui.component.SmoothTipList;
import org.apache.ctakes.gui.pipeline.bit.BitCellRenderer;
import org.apache.ctakes.gui.pipeline.bit.PipeBitFinder;
import org.apache.ctakes.gui.pipeline.bit.available.AvailablesListModel;
import org.apache.ctakes.gui.pipeline.bit.available.AvailablesRenderer;
import org.apache.ctakes.gui.pipeline.bit.info.PipeBitInfoPanel;
import org.apache.ctakes.gui.pipeline.bit.user.DefaultUserBit;
import org.apache.ctakes.gui.pipeline.bit.user.UserBit;
import org.apache.ctakes.gui.pipeline.bit.user.UserBitInfoPanel;
import org.apache.ctakes.gui.pipeline.bit.user.UserBitListModel;
import org.apache.ctakes.gui.pipeline.bit.user.UserBitRenderer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

final class MainPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger((String)"MainPanel");
    private final AvailablesListModel _availablesListModel = new AvailablesListModel();
    private JList<PipeBitInfo> _availablesList;
    private JList<UserBit> _userBitsList;

    MainPanel() {
        super(new BorderLayout(10, 10));
        PositionedSplitPane logSplit = new PositionedSplitPane(0);
        logSplit.setTopComponent(this.createMainPanel());
        logSplit.setBottomComponent(LoggerPanel.createLoggerPanel(new Level[0]));
        ((JSplitPane)logSplit).setDividerLocation(0.6);
        this.add((Component)logSplit, "Center");
    }

    private JComponent createWestPanel() {
        JLabel header = new JLabel("Available Pipe Bits");
        header.setPreferredSize(new Dimension(100, 30));
        header.setHorizontalAlignment(0);
        this._availablesList = MainPanel.createPipeBitList(this._availablesListModel);
        AvailablesRenderer availableRenderer = new AvailablesRenderer();
        this._availablesList.setCellRenderer(availableRenderer);
        JScrollPane scroll = new JScrollPane(this._availablesList);
        scroll.setColumnHeaderView(header);
        scroll.setHorizontalScrollBarPolicy(31);
        PositionedSplitPane split = new PositionedSplitPane();
        split.setLeftComponent(scroll);
        split.setRightComponent(MainPanel.createBitInfoPanel(this._availablesList));
        ((JSplitPane)split).setDividerLocation(0.3);
        return split;
    }

    private JComponent createEastPanel() {
        JLabel header = new JLabel("User Pipeline");
        header.setPreferredSize(new Dimension(100, 30));
        header.setHorizontalAlignment(0);
        UserBitListModel userBitListModel = new UserBitListModel();
        this._userBitsList = MainPanel.createUserBitList(userBitListModel);
        UserBitRenderer usersRenderer = new UserBitRenderer();
        this._userBitsList.setCellRenderer(usersRenderer);
        JScrollPane scroll = new JScrollPane(this._userBitsList);
        scroll.setColumnHeaderView(header);
        AvailablesMouseListener availablesMouse = new AvailablesMouseListener(this._availablesList, userBitListModel);
        this._availablesList.addMouseListener(availablesMouse);
        this._availablesList.addMouseMotionListener(availablesMouse);
        UsersMouseListener usersMouse = new UsersMouseListener(this._userBitsList, userBitListModel);
        this._userBitsList.addMouseListener(usersMouse);
        this._userBitsList.addMouseMotionListener(usersMouse);
        PositionedSplitPane split = new PositionedSplitPane();
        split.setLeftComponent(scroll);
        split.setRightComponent(MainPanel.createUserBitPanel(this._userBitsList));
        ((JSplitPane)split).setDividerLocation(0.3);
        return split;
    }

    private JComponent createMainPanel() {
        JComponent westPanel = this.createWestPanel();
        JComponent eastPanel = this.createEastPanel();
        return new JSplitPane(1, westPanel, eastPanel);
    }

    private static JList<PipeBitInfo> createPipeBitList(ListModel<PipeBitInfo> model) {
        SmoothTipList<PipeBitInfo> bitList = new SmoothTipList<PipeBitInfo>(model);
        bitList.setCellRenderer(new BitCellRenderer());
        bitList.setFixedCellHeight(20);
        return bitList;
    }

    private static JList<UserBit> createUserBitList(ListModel<UserBit> model) {
        SmoothTipList<UserBit> bitList = new SmoothTipList<UserBit>(model);
        bitList.setFixedCellHeight(20);
        return bitList;
    }

    private static PipeBitInfoPanel createBitInfoPanel(JList<PipeBitInfo> list) {
        PipeBitInfoPanel pipeBitInfoPanel = new PipeBitInfoPanel();
        pipeBitInfoPanel.setPipeBitInfoList(list);
        return pipeBitInfoPanel;
    }

    private static UserBitInfoPanel createUserBitPanel(JList<UserBit> list) {
        UserBitInfoPanel userBitPanelPanel = new UserBitInfoPanel();
        userBitPanelPanel.setUserBitList(list);
        return userBitPanelPanel;
    }

    private JComponent createGoPanel() {
        return new JButton(new FindPipeBitsAction());
    }

    public void findPipeBits() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new PiperBitParser());
    }

    private static final class UsersMouseListener
    extends MouseAdapter {
        private final JList<UserBit> _list;
        private final UserBitListModel __userBitListModel;
        private int _currentFocusIndex = -1;

        private UsersMouseListener(JList<UserBit> list, UserBitListModel userBitListModel) {
            this._list = list;
            this.__userBitListModel = userBitListModel;
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            Point p = this._list.getMousePosition();
            int widthMinusX = this._list.getWidth() - p.x;
            if (widthMinusX > 65) {
                return;
            }
            this._list.getSelectionModel().clearSelection();
            UserBitRenderer.SUSPEND_BUTTONS = true;
            int index = this._list.locationToIndex(p);
            if (widthMinusX > 45) {
                this.__userBitListModel.moveUserBitUp(index);
            } else if (widthMinusX > 25) {
                this.__userBitListModel.moveUserBitDown(index);
            } else {
                this.__userBitListModel.removeUserBit(index);
            }
            UserBitRenderer.SUSPEND_BUTTONS = false;
            this._list.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            this.setFocus(this._list.getMousePosition());
        }

        @Override
        public void mouseExited(MouseEvent event) {
            this.setFocus(this._list.getMousePosition());
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            this.setFocus(this._list.getMousePosition());
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            this.setFocus(this._list.getMousePosition());
        }

        private void setFocus(Point p) {
            if (p == null) {
                if (this._currentFocusIndex >= 0) {
                    this._currentFocusIndex = -1;
                    this._list.repaint();
                }
                return;
            }
            int index = this._list.locationToIndex(p);
            if (index == this._currentFocusIndex) {
                return;
            }
            this._currentFocusIndex = index;
            this._list.repaint();
        }
    }

    private static final class AvailablesMouseListener
    extends MouseAdapter {
        private final JList<PipeBitInfo> _list;
        private final UserBitListModel __userBitListModel;
        private int _currentFocusIndex = -1;

        private AvailablesMouseListener(JList<PipeBitInfo> list, UserBitListModel userBitListModel) {
            this._list = list;
            this.__userBitListModel = userBitListModel;
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            Point p = this._list.getMousePosition();
            if (p.getX() < (double)(this._list.getWidth() - 37)) {
                return;
            }
            int index = this._list.locationToIndex(p);
            AvailablesListModel availablesModel = (AvailablesListModel)this._list.getModel();
            PipeBitInfo pipeBitInfo = availablesModel.getElementAt(index);
            DefaultUserBit userBit = new DefaultUserBit(pipeBitInfo, availablesModel.getPipeBit(pipeBitInfo));
            this.__userBitListModel.addUserBit(userBit);
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            this.setFocus(this._list.getMousePosition());
        }

        @Override
        public void mouseExited(MouseEvent event) {
            this.setFocus(this._list.getMousePosition());
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            this.setFocus(this._list.getMousePosition());
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            this.setFocus(this._list.getMousePosition());
        }

        private void setFocus(Point p) {
            if (p == null) {
                if (this._currentFocusIndex >= 0) {
                    this._currentFocusIndex = -1;
                    this._list.repaint();
                }
                return;
            }
            int index = this._list.locationToIndex(p);
            if (index == this._currentFocusIndex) {
                return;
            }
            this._currentFocusIndex = index;
            this._list.repaint();
        }
    }

    private class FindPipeBitsAction
    extends AbstractAction {
        private FindPipeBitsAction() {
            super("Find Readers, Annotators and Writers");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.execute(new PiperBitParser());
        }
    }

    private class PiperBitParser
    implements Runnable {
        private PiperBitParser() {
        }

        @Override
        public void run() {
            JFrame frame = (JFrame)SwingUtilities.getRoot(MainPanel.this);
            frame.setCursor(Cursor.getPredefinedCursor(3));
            DisablerPane.getInstance().setVisible(true);
            PipeBitFinder.getInstance().scan();
            MainPanel.this._availablesListModel.setPipeBits(PipeBitFinder.getInstance().getPipeBits());
            DisablerPane.getInstance().setVisible(false);
            frame.setCursor(Cursor.getDefaultCursor());
        }
    }
}

