/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.gui.util.IconLoader;
import org.apache.log4j.Logger;

public enum PipeBitPainter {
    INSTANCE;

    private static final Logger LOGGER;
    private static final Color READER_COLOR;
    private static final Color ANNOTATOR_COLOR;
    private static final Color WRITER_COLOR;
    private static final Color SPECIAL_COLOR;
    private static final String READER_ICON_FILE = "GreenArrowIn.png";
    private static final String ANNOTATOR_ICON_FILE = "BlueGear.png";
    private static final String WRITER_ICON_FILE = "BlueArrowOut.png";
    private static final String SPECIAL_ICON_FILE = "Utilities.png";
    private static final Border EMPTY_BORDER;
    private Icon READER_ICON = null;
    private Icon ANNOTATOR_ICON = null;
    private Icon WRITER_ICON = null;
    private Icon SPECIAL_ICON = null;
    private boolean _iconLoadAttempted;

    public static PipeBitPainter getInstance() {
        return INSTANCE;
    }

    public synchronized void loadIcons() {
        if (this._iconLoadAttempted) {
            return;
        }
        this._iconLoadAttempted = true;
        SwingUtilities.invokeLater(new PipeBitIconLoader());
    }

    public void paintObject(Component renderer, Object value, boolean isSelected) {
        if (PipeBitInfo.class.isInstance(value)) {
            this.paintPipeBitInfo(renderer, (PipeBitInfo)value, isSelected);
        } else {
            LOGGER.error((Object)(value.getClass().getName() + " is not a PipeBitInfo"));
            renderer.setBackground(Color.DARK_GRAY);
            PipeBitPainter.setText(renderer, "Invalid");
            PipeBitPainter.setToolTipText(renderer, "Invalid Information");
        }
    }

    public void paintPipeBitInfo(Component renderer, PipeBitInfo info, boolean isSelected) {
        if (!isSelected) {
            switch (info.role()) {
                case READER: {
                    renderer.setForeground(READER_COLOR);
                    break;
                }
                case ANNOTATOR: {
                    renderer.setForeground(ANNOTATOR_COLOR);
                    break;
                }
                case WRITER: {
                    renderer.setForeground(WRITER_COLOR);
                    break;
                }
                case SPECIAL: {
                    renderer.setForeground(SPECIAL_COLOR);
                }
            }
        }
        this.setIcon(renderer, info);
        PipeBitPainter.setText(renderer, info.name());
        PipeBitPainter.setToolTipText(renderer, info.description());
    }

    private void setIcon(Component renderer, PipeBitInfo info) {
        if (!JLabel.class.isInstance(renderer)) {
            return;
        }
        ((JLabel)renderer).setBorder(EMPTY_BORDER);
        switch (info.role()) {
            case READER: {
                ((JLabel)renderer).setIcon(this.READER_ICON);
                break;
            }
            case ANNOTATOR: {
                ((JLabel)renderer).setIcon(this.ANNOTATOR_ICON);
                break;
            }
            case WRITER: {
                ((JLabel)renderer).setIcon(this.WRITER_ICON);
                break;
            }
            case SPECIAL: {
                ((JLabel)renderer).setIcon(this.SPECIAL_ICON);
            }
        }
    }

    private static void setText(Component renderer, String text) {
        if (!JLabel.class.isInstance(renderer)) {
            LOGGER.error((Object)("Renderer " + renderer.getClass().getName() + " is not a JLabel"));
            return;
        }
        ((JLabel)renderer).setText(text);
    }

    private static void setToolTipText(Component renderer, String text) {
        if (!JComponent.class.isInstance(renderer)) {
            LOGGER.error((Object)("Renderer " + renderer.getClass().getName() + " is not a JComponent"));
            return;
        }
        ((JComponent)renderer).setToolTipText(text);
    }

    static {
        LOGGER = Logger.getLogger((String)"PipeBitPainter");
        READER_COLOR = Color.GREEN.darker().darker();
        ANNOTATOR_COLOR = Color.CYAN.darker().darker();
        WRITER_COLOR = Color.BLUE;
        SPECIAL_COLOR = Color.MAGENTA.darker();
        EMPTY_BORDER = new EmptyBorder(0, 5, 0, 0);
    }

    private final class PipeBitIconLoader
    implements Runnable {
        private static final int ICON_SIZE = 16;
        private static final String ICON_DIR = "org/apache/ctakes/gui/pipeline/icon/";

        private PipeBitIconLoader() {
        }

        @Override
        public void run() {
            PipeBitPainter.this.READER_ICON = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/GreenArrowIn.png", 16);
            PipeBitPainter.this.ANNOTATOR_ICON = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/BlueGear.png", 16);
            PipeBitPainter.this.WRITER_ICON = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/BlueArrowOut.png", 16);
            PipeBitPainter.this.SPECIAL_ICON = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/Utilities.png", 16);
        }
    }
}

