/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.info;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.gui.util.ColorFactory;

public enum ProductIconFactory {
    INSTANCE;

    private final Map<PipeBitInfo.TypeProduct, Icon> _typeProductIcons = new EnumMap<PipeBitInfo.TypeProduct, Icon>(PipeBitInfo.TypeProduct.class);

    public static ProductIconFactory getInstance() {
        return INSTANCE;
    }

    private ProductIconFactory() {
        new ProductIconMaker().run();
    }

    public Icon getIcon(PipeBitInfo.TypeProduct typeProduct) {
        return this._typeProductIcons.get(typeProduct);
    }

    private final class ProductIconMaker
    implements Runnable {
        private final Stroke LINE_STROKE = new BasicStroke(4.0f, 1, 1);
        private final Font HINT_FONT = new Font("Dialog", 1, 12);

        private ProductIconMaker() {
        }

        @Override
        public void run() {
            Arrays.stream(PipeBitInfo.TypeProduct.values()).forEach(tp -> ProductIconFactory.this._typeProductIcons.put(tp, this.createIcon((PipeBitInfo.TypeProduct)tp)));
        }

        private Icon createIcon(PipeBitInfo.TypeProduct typeProduct) {
            BufferedImage image = new BufferedImage(20, 20, 5);
            Graphics2D g2 = (Graphics2D)((Image)image).getGraphics();
            g2.setColor(UIManager.getColor("List.background"));
            g2.fillRect(0, 0, 20, 20);
            g2.setColor(Color.LIGHT_GRAY);
            g2.drawOval(2, 2, 17, 17);
            String name = typeProduct.name();
            Color color = ColorFactory.getColor(name);
            g2.setColor(ColorFactory.addTransparency(color, 159));
            g2.setFont(this.HINT_FONT);
            g2.drawString(typeProduct.name().charAt(0) + "", 4, 15);
            GeneralPath linePath = new GeneralPath(0, 3);
            int[] xArray = new int[]{11, 17, 11};
            int[] yArray = new int[]{3, 9, 17};
            linePath.moveTo(xArray[0], yArray[0]);
            for (int i = 1; i < xArray.length; ++i) {
                linePath.lineTo(xArray[i], yArray[i]);
            }
            g2.setStroke(this.LINE_STROKE);
            g2.draw(linePath);
            return new ImageIcon(image);
        }
    }
}

