/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.constituency.parser.ae;

import java.io.FileNotFoundException;
import org.apache.ctakes.constituency.parser.MaxentParserWrapper;
import org.apache.ctakes.constituency.parser.ParserWrapper;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Constituency Parser", description=".", dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.SENTENCE})
public class ConstituencyParser
extends JCasAnnotator_ImplBase {
    public static final String PARAM_MODEL_FILENAME = "MODEL_FILENAME";
    @ConfigurationParameter(name="MODEL_FILENAME", description="File containing the opennlp-trained parser model", mandatory=false, defaultValue={"org/apache/ctakes/constituency/parser/models/sharpacq-3.1.bin"})
    private String modelFilename;
    private ParserWrapper parser = null;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            this.logger.info((Object)"Initializing parser...");
            this.parser = new MaxentParserWrapper(FileLocator.getAsStream((String)this.modelFilename));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.logger.error((Object)("Error reading parser model file/directory: " + e.getMessage()));
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        this.parser.createAnnotations(jcas);
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ConstituencyParser.class, (Object[])new Object[]{PARAM_MODEL_FILENAME, modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ConstituencyParser.class, (Object[])new Object[0]);
    }
}

