/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.chunker.ae;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import org.apache.ctakes.chunker.ae.ChunkCreator;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Chunker", description="Annotator that generates chunks of any kind as specified by the chunker model and the chunk creator.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN}, products={PipeBitInfo.TypeProduct.CHUNK})
public class Chunker
extends JCasAnnotator_ImplBase {
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    public static final String CHUNKER_MODEL_FILE_PARAM = "ChunkerModelFile";
    public static final String PARAM_CHUNKER_MODEL_FILE = "ChunkerModelFile";
    @ConfigurationParameter(name="ChunkerModelFile", mandatory=false, defaultValue={"org/apache/ctakes/chunker/models/chunker-model.zip"}, description="Model file for OpenNLP chunker")
    private String chunkerModelPath;
    public static final String CHUNKER_CREATOR_CLASS_PARAM = "ChunkCreatorClass";
    public static final String PARAM_CHUNKER_CREATOR_CLASS = "ChunkCreatorClass";
    @ConfigurationParameter(name="ChunkCreatorClass", mandatory=false, defaultValue={"org.apache.ctakes.chunker.ae.DefaultChunkCreator"}, description="The class that will create the chunks")
    String chunkerCreatorClassName;
    private opennlp.tools.chunker.Chunker chunker;
    ChunkCreator chunkerCreator;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        this.logger.info((Object)("Chunker model file: " + this.chunkerModelPath));
        try (InputStream fis = FileLocator.getAsStream((String)this.chunkerModelPath);){
            ChunkerModel model = new ChunkerModel(fis);
            this.chunker = new ChunkerME(model);
        }
        catch (IOException e) {
            this.logger.info((Object)("Chunker model: " + this.chunkerModelPath));
            throw new ResourceInitializationException((Throwable)e);
        }
        try {
            this.chunkerCreator = (ChunkCreator)Class.forName(this.chunkerCreatorClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.logger.error((Object)("Error creating chunkerCreator from classname: " + this.chunkerCreatorClassName));
            throw new ResourceInitializationException((Throwable)e);
        }
        this.chunkerCreator.initialize(uimaContext);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        this.logger.info((Object)" process(JCas)");
        Collection sentences = JCasUtil.select((JCas)jCas, Sentence.class);
        for (Sentence sentence : sentences) {
            int chunkEnd;
            List tokens = JCasUtil.selectCovered(BaseToken.class, (AnnotationFS)sentence);
            String[] words = new String[tokens.size()];
            String[] tags = new String[tokens.size()];
            for (int i = 0; i < tokens.size(); ++i) {
                words[i] = ((BaseToken)tokens.get(i)).getCoveredText();
                tags[i] = ((BaseToken)tokens.get(i)).getPartOfSpeech();
            }
            String[] chunks = this.chunker.chunk(words, tags);
            int chunkBegin = 0;
            String chunkType = "";
            for (int i = 0; i < chunks.length; ++i) {
                if (i > 0 && !chunks[i].startsWith("I-")) {
                    chunkEnd = ((BaseToken)tokens.get(i - 1)).getEnd();
                    this.chunkerCreator.createChunk(jCas, chunkBegin, chunkEnd, chunkType);
                }
                if (chunks[i].startsWith("B-")) {
                    chunkBegin = ((BaseToken)tokens.get(i)).getBegin();
                    chunkType = chunks[i].substring(2);
                    continue;
                }
                if (!chunks[i].equals("O")) continue;
                chunkBegin = ((BaseToken)tokens.get(i)).getBegin();
                chunkType = chunks[i];
            }
            if (chunks.length <= 0 || chunks[chunks.length - 1].equals("O")) continue;
            chunkEnd = ((BaseToken)tokens.get(chunks.length - 1)).getEnd();
            this.chunkerCreator.createChunk(jCas, chunkBegin, chunkEnd, chunkType);
        }
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(Chunker.class, (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelFile) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(Chunker.class, (Object[])new Object[]{"ChunkerModelFile", modelFile});
    }
}

