/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.component.animation;

import java.io.Serializable;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;

public class BehaviorStateHolderSaver {
    private String className;
    private Serializable savedState = null;

    public BehaviorStateHolderSaver(FacesContext context, Object toSave) {
        this.className = toSave.getClass().getName();
        if (toSave instanceof StateHolder) {
            if (!((StateHolder)toSave).isTransient()) {
                this.savedState = (Serializable)((StateHolder)toSave).saveState(context);
            } else {
                this.className = null;
            }
        } else if (toSave instanceof Serializable) {
            this.savedState = (Serializable)toSave;
            this.className = null;
        }
    }

    public Object restore(FacesContext context) throws IllegalStateException {
        Class toRestoreClass;
        Object result = null;
        if (null == this.className && null != this.savedState) {
            return this.savedState;
        }
        if (this.className == null) {
            return null;
        }
        try {
            toRestoreClass = BehaviorStateHolderSaver.loadClass(this.className, this);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        if (null != toRestoreClass) {
            try {
                result = toRestoreClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException a) {
                throw new IllegalStateException(a);
            }
        }
        if (null != result && null != this.savedState && result instanceof StateHolder) {
            ((StateHolder)result).restoreState(context, (Object)this.savedState);
        }
        return result;
    }

    private static Class loadClass(String name, Object fallbackClass) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return Class.forName(name, false, loader);
    }
}

