/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.component.checkboxbutton;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;
import org.icefaces.component.checkboxbutton.CheckboxButton;
import org.icefaces.component.utils.JSONBuilder;
import org.icefaces.component.utils.ScriptWriter;
import org.icefaces.component.utils.Utils;
import org.icefaces.render.MandatoryResourceComponent;
import org.icefaces.util.EnvUtils;

@MandatoryResourceComponent(value="org.icefaces.component.checkboxbutton.CheckboxButton")
public class CheckboxButtonRenderer
extends Renderer {
    List<UIParameter> uiParamChildren;

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        CheckboxButton checkbox = (CheckboxButton)uiComponent;
        String source = String.valueOf(requestParameterMap.get("ice.event.captured"));
        String clientId = uiComponent.getClientId();
        String hiddenValue = String.valueOf(requestParameterMap.get(clientId + "_hidden"));
        boolean submittedValue = this.isChecked(hiddenValue);
        checkbox.setSubmittedValue(submittedValue);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        CheckboxButton checkbox = (CheckboxButton)uiComponent;
        this.uiParamChildren = Utils.captureParameters((UIComponent)checkbox);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)"ice-checkboxbutton", null);
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_span"), null);
        String yuiBaseClass = "yui-button yui-min yui-checkboxButton-button";
        String styleClass = checkbox.getStyleClass();
        if (null != styleClass) {
            yuiBaseClass = yuiBaseClass + " " + String.valueOf(styleClass);
        }
        writer.writeAttribute("styleClass", (Object)yuiBaseClass, null);
        String style = checkbox.getStyle();
        if (style != null && style.trim().length() > 0) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"first-child", null);
        writer.writeAttribute("id", (Object)(clientId + "_s2"), null);
        String label = this.findCheckboxLabel(checkbox);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("name", (Object)(clientId + "_button"), null);
        writer.writeAttribute("id", (Object)(clientId + "_button"), null);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        CheckboxButton checkbox = (CheckboxButton)uiComponent;
        String label = this.findCheckboxLabel(checkbox);
        writer.endElement("button");
        writer.endElement("span");
        writer.endElement("span");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)(clientId + "_hidden"), null);
        writer.writeAttribute("id", (Object)(clientId + "_hidden"), null);
        writer.writeAttribute("value", checkbox.getValue(), null);
        writer.endElement("input");
        String boxValue = String.valueOf(checkbox.getValue());
        boolean isChecked = this.isChecked(boxValue);
        StringBuilder sb = new StringBuilder();
        sb.append(checkbox.getStyle()).append(checkbox.getStyleClass());
        boolean ariaEnabled = EnvUtils.isAriaEnabled((FacesContext)facesContext);
        Integer tabindex = checkbox.getTabindex();
        if (ariaEnabled && tabindex == null) {
            tabindex = 0;
        }
        JSONBuilder jsonBuilder = JSONBuilder.create().beginMap();
        String builder = "";
        JSONBuilder.create().beginMap().entry("nothing", label).toString();
        jsonBuilder.entry("type", "checkbox").entry("checked", isChecked).entry("disabled", checkbox.isDisabled());
        if (tabindex != null) {
            jsonBuilder.entry("tabindex", tabindex);
        }
        builder = jsonBuilder.entry("label", label).endMap().toString();
        JSONBuilder jBuild = JSONBuilder.create().beginMap().entry("singleSubmit", checkbox.isSingleSubmit()).entry("hashCode", sb.toString().hashCode()).entry("ariaEnabled", ariaEnabled);
        if (this.uiParamChildren != null) {
            jBuild.entry("postParameters", Utils.asStringArray(this.uiParamChildren));
        }
        String params = "'" + clientId + "'," + builder + "," + jBuild.endMap().toString();
        String finalScript = "ice.component.checkboxbutton.updateProperties(" + params + ");";
        ScriptWriter.insertScript(facesContext, uiComponent, finalScript);
        writer.endElement("div");
    }

    private String findCheckboxLabel(CheckboxButton checkbox) {
        String label = "";
        String checkLabel = checkbox.getLabel();
        if (null != checkLabel && !checkLabel.equals("")) {
            label = checkLabel;
        }
        return label;
    }

    private boolean isChecked(String hiddenValue) {
        return hiddenValue.equalsIgnoreCase("on") || hiddenValue.equalsIgnoreCase("yes") || hiddenValue.equalsIgnoreCase("true");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        if (submittedValue instanceof Boolean) {
            return submittedValue;
        }
        return Boolean.valueOf(submittedValue.toString());
    }
}

