/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.ctakes.ytex.kernel.BagOfWordsData;
import org.apache.ctakes.ytex.kernel.BagOfWordsDecorator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class AbstractBagOfWordsExporter {
    protected SimpleJdbcTemplate simpleJdbcTemplate;
    protected JdbcTemplate jdbcTemplate;
    protected PlatformTransactionManager transactionManager;
    protected TransactionTemplate txNew;

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.txNew = new TransactionTemplate(transactionManager);
        this.txNew.setPropagationBehavior(3);
    }

    public void setDataSource(DataSource ds) {
        this.jdbcTemplate = new JdbcTemplate(ds);
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(ds);
    }

    public DataSource getDataSource(DataSource ds) {
        return this.jdbcTemplate.getDataSource();
    }

    protected void getNumericInstanceWords(final String sql, final BagOfWordsData bagOfWordsData) {
        this.txNew.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus txStatus) {
                AbstractBagOfWordsExporter.this.jdbcTemplate.query(new PreparedStatementCreator(){

                    public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                        return conn.prepareStatement(sql, 1003, 1007);
                    }
                }, new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        int instanceId = rs.getInt(1);
                        String word = rs.getString(2);
                        double wordValue = rs.getDouble(3);
                        AbstractBagOfWordsExporter.this.addNumericWordToInstance(bagOfWordsData, instanceId, word, wordValue);
                    }
                });
                return null;
            }
        });
    }

    protected void addNumericWordToInstance(BagOfWordsData bagOfWordsData, int instanceId, String word, double wordValue) {
        SortedMap<String, Double> words = bagOfWordsData.getInstanceNumericWords().get(instanceId);
        if (words == null) {
            words = new TreeMap<String, Double>();
            bagOfWordsData.getInstanceNumericWords().put(instanceId, words);
        }
        words.put(word, wordValue);
        bagOfWordsData.getNumericWords().add(word);
        Integer docLength = bagOfWordsData.getDocLengthMap().get(instanceId);
        if (docLength == null) {
            docLength = 0;
        }
        bagOfWordsData.getDocLengthMap().put(instanceId, docLength + (int)wordValue);
        Integer docsWithWord = bagOfWordsData.getIdfMap().get(word);
        if (docsWithWord == null) {
            docsWithWord = 0;
        }
        bagOfWordsData.getIdfMap().put(word, docsWithWord + 1);
    }

    protected void addNominalWordToInstance(BagOfWordsData bagOfWordsData, int instanceId, String word, String wordValue) {
        SortedMap<String, String> instanceWords = bagOfWordsData.getInstanceNominalWords().get(instanceId);
        TreeSet<String> wordValueSet = (TreeSet<String>)bagOfWordsData.getNominalWordValueMap().get(word);
        if (instanceWords == null) {
            instanceWords = new TreeMap<String, String>();
            bagOfWordsData.getInstanceNominalWords().put(instanceId, instanceWords);
        }
        if (wordValueSet == null) {
            wordValueSet = new TreeSet<String>();
            bagOfWordsData.getNominalWordValueMap().put(word, wordValueSet);
        }
        instanceWords.put(word, wordValue);
        wordValueSet.add(wordValue);
    }

    protected void getNominalInstanceWords(final String sql, final BagOfWordsData bagOfWordsData) {
        this.txNew.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus txStatus) {
                AbstractBagOfWordsExporter.this.jdbcTemplate.query(new PreparedStatementCreator(){

                    public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                        return conn.prepareStatement(sql, 1003, 1007);
                    }
                }, new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        int instanceId = rs.getInt(1);
                        String word = rs.getString(2);
                        String wordValue = rs.getString(3);
                        AbstractBagOfWordsExporter.this.addNominalWordToInstance(bagOfWordsData, instanceId, word, wordValue);
                    }
                });
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties(String propertyFile, Properties props) throws FileNotFoundException, IOException, InvalidPropertiesFormatException {
        try (FileInputStream in = null;){
            in = new FileInputStream(propertyFile);
            if (propertyFile.endsWith(".xml")) {
                props.loadFromXML(in);
            } else {
                props.load(in);
            }
        }
    }

    protected void loadData(BagOfWordsData bagOfWordsData, String instanceNumericWordQuery, String instanceNominalWordQuery, BagOfWordsDecorator bDecorator) {
        if (instanceNumericWordQuery.trim().length() > 0) {
            this.getNumericInstanceWords(instanceNumericWordQuery, bagOfWordsData);
        }
    }
}

