/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.evaluator;

import org.apache.ctakes.ytex.kernel.evaluator.ConvolutionKernel;
import org.apache.ctakes.ytex.kernel.tree.Node;

public class NamedEntityNegationKernel
extends ConvolutionKernel {
    private static final String CONF_ATTR = "confidence";
    private static final String CERT_ATTR = "certainty";

    @Override
    public double evaluate(Object c1, Object c2) {
        Node ne1 = (Node)c1;
        Node ne2 = (Node)c2;
        Number confidence1 = (Number)ne1.getValue().get(CONF_ATTR);
        Number confidence2 = (Number)ne2.getValue().get(CONF_ATTR);
        Integer certainty1 = (Integer)ne1.getValue().get(CERT_ATTR);
        Integer certainty2 = (Integer)ne2.getValue().get(CERT_ATTR);
        double negationFactor = 1.0;
        if (confidence1 != null && confidence2 != null && !confidence1.equals(confidence2)) {
            negationFactor = -1.0;
        }
        double certaintyFactor = 1.0;
        if (certainty1 != null && certainty1 != null && !certainty1.equals(certainty2)) {
            certaintyFactor = 0.5;
        }
        return negationFactor * certaintyFactor * super.evaluate(c1, c2);
    }
}

